package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可修改站点监控任务。 */
public class MonitorModifySiteMonitorApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorModifySiteMonitorApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/modify-site-monitor",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ModifySiteMonitorResponse send(Credential credential, ModifySiteMonitorRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ModifySiteMonitorResponse.class);
    }

    public static class ModifySiteMonitorRequest {
        /** 站点监控任务ID */
        @JsonProperty("siteID")
        private String siteID;

        /** 站点监控任务名称，支持中英文 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示探测类型。取值范围：<br>
         * http：http探测。<br>
         * ping：ping探测。<br>
         * tcp：tcp探测。<br>
         * udp：udp探测。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("protocol")
        private String protocol;

        /**
         * 站点地址。<br>
         * ping示例：www.baidu.com<br>
         * tcp/udp示例：www.baidu.com:80<br>
         * http示例：http://www.baidu.com或https://www.baidu.com
         */
        @JsonProperty("address")
        private String address;

        /** 探测间隔，单位秒 */
        @JsonProperty("evalInterval")
        private Integer evalInterval;

        /** 探测节点列表，如['East_China','North_China']，可用探测节点可通过探测节点：查询列表接口获取 */
        @JsonProperty("probePoint")
        private List<String> probePoint;

        public String getSiteID() {
            return this.siteID;
        }

        public void setSiteID(String siteID) {
            this.siteID = siteID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public Integer getEvalInterval() {
            return this.evalInterval;
        }

        public void setEvalInterval(Integer evalInterval) {
            this.evalInterval = evalInterval;
        }

        public List<String> getProbePoint() {
            return this.probePoint;
        }

        public void setProbePoint(List<String> probePoint) {
            this.probePoint = probePoint;
        }
    }

    public static class ModifySiteMonitorResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private ModifySiteMonitorReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public ModifySiteMonitorReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ModifySiteMonitorReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ModifySiteMonitorReturnObjResponse {
        /** 站点监控任务ID */
        @JsonProperty("siteID")
        private String siteID;

        public String getSiteID() {
            return this.siteID;
        }

        public void setSiteID(String siteID) {
            this.siteID = siteID;
        }
    }
}
