package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询告警黑名单列表。 */
public class MonitorQueryAlarmBlacklistsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryAlarmBlacklistsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/query-alarm-blacklists",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryAlarmBlacklistsResponse send(
            Credential credential, QueryAlarmBlacklistsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.instanceName != null) {
            ctReq.addParam("instanceName", request.instanceName);
            request.instanceName = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.service != null) {
            ctReq.addParam("service", request.service);
            request.service = null;
        }
        if (request.dimension != null) {
            ctReq.addParam("dimension", request.dimension);
            request.dimension = null;
        }
        if (request.contactGroupID != null) {
            ctReq.addParam("contactGroupID", request.contactGroupID);
            request.contactGroupID = null;
        }
        if (request.contactGroupName != null) {
            ctReq.addParam("contactGroupName", request.contactGroupName);
            request.contactGroupName = null;
        }
        if (request.createTimeFrom != null) {
            ctReq.addParam("createTimeFrom", String.valueOf(request.createTimeFrom));
            request.createTimeFrom = null;
        }
        if (request.createTimeTill != null) {
            ctReq.addParam("createTimeTill", String.valueOf(request.createTimeTill));
            request.createTimeTill = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryAlarmBlacklistsResponse.class);
    }

    public static class QueryAlarmBlacklistsRequest {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 实例名称 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 告警黑名单名称 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警维度。取值范围：<br>
         * ecs：云主机。<br>
         * disk：磁盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("dimension")
        private String dimension;

        /** 联系人组ID */
        @JsonProperty("contactGroupID")
        private String contactGroupID;

        /** 联系人组名称 */
        @JsonProperty("contactGroupName")
        private String contactGroupName;

        /** 创建告警黑名单起始时间，毫秒级时间戳。 */
        @JsonProperty("createTimeFrom")
        private Integer createTimeFrom;

        /** 创建告警黑名单截止时间，毫秒级时间戳。 */
        @JsonProperty("createTimeTill")
        private Integer createTimeTill;

        /** 页码，默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 每页大小，默认为20 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getContactGroupID() {
            return this.contactGroupID;
        }

        public void setContactGroupID(String contactGroupID) {
            this.contactGroupID = contactGroupID;
        }

        public String getContactGroupName() {
            return this.contactGroupName;
        }

        public void setContactGroupName(String contactGroupName) {
            this.contactGroupName = contactGroupName;
        }

        public Integer getCreateTimeFrom() {
            return this.createTimeFrom;
        }

        public void setCreateTimeFrom(Integer createTimeFrom) {
            this.createTimeFrom = createTimeFrom;
        }

        public Integer getCreateTimeTill() {
            return this.createTimeTill;
        }

        public void setCreateTimeTill(Integer createTimeTill) {
            this.createTimeTill = createTimeTill;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryAlarmBlacklistsResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryAlarmBlacklistsReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryAlarmBlacklistsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryAlarmBlacklistsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryAlarmBlacklistsReturnObjResponse {
        /** 告警黑名单列表 */
        @JsonProperty("AlarmBlacklists")
        private List<QueryAlarmBlacklistsReturnObjAlarmBlacklistsResponse> alarmBlacklists;

        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 当前页记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public List<QueryAlarmBlacklistsReturnObjAlarmBlacklistsResponse> getAlarmBlacklists() {
            return this.alarmBlacklists;
        }

        public void setAlarmBlacklists(
                List<QueryAlarmBlacklistsReturnObjAlarmBlacklistsResponse> alarmBlacklists) {
            this.alarmBlacklists = alarmBlacklists;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class QueryAlarmBlacklistsReturnObjAlarmBlacklistsResponse {
        /** 告警黑名单ID */
        @JsonProperty("blacklistID")
        private String blacklistID;

        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 告警黑名单名称 */
        @JsonProperty("name")
        private String name;

        /** 服务 */
        @JsonProperty("service")
        private String service;

        /** 维度 */
        @JsonProperty("dimension")
        private String dimension;

        /** 描述 */
        @JsonProperty("desc")
        private String desc;

        /** 资源信息列表 */
        @JsonProperty("resources")
        private List<QueryAlarmBlacklistsReturnObjAlarmBlacklistsResourcesResponse> resources;

        /** 联系组列表 */
        @JsonProperty("contactGroupList")
        private List<String> contactGroupList;

        /** 指标列表 */
        @JsonProperty("metrics")
        private List<String> metrics;

        /** 开始时间 */
        @JsonProperty("startTime")
        private Integer startTime;

        /** 结束时间 */
        @JsonProperty("endTime")
        private Integer endTime;

        /** 告警黑名单状态 */
        @JsonProperty("status")
        private Integer status;

        /** 最近更新时间, 时间戳，精确到毫秒 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        /** 创建时间，时间戳，精确到毫秒 */
        @JsonProperty("createTime")
        private Integer createTime;

        public String getBlacklistID() {
            return this.blacklistID;
        }

        public void setBlacklistID(String blacklistID) {
            this.blacklistID = blacklistID;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public List<QueryAlarmBlacklistsReturnObjAlarmBlacklistsResourcesResponse> getResources() {
            return this.resources;
        }

        public void setResources(
                List<QueryAlarmBlacklistsReturnObjAlarmBlacklistsResourcesResponse> resources) {
            this.resources = resources;
        }

        public List<String> getContactGroupList() {
            return this.contactGroupList;
        }

        public void setContactGroupList(List<String> contactGroupList) {
            this.contactGroupList = contactGroupList;
        }

        public List<String> getMetrics() {
            return this.metrics;
        }

        public void setMetrics(List<String> metrics) {
            this.metrics = metrics;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Integer endTime) {
            this.endTime = endTime;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }
    }

    public static class QueryAlarmBlacklistsReturnObjAlarmBlacklistsResourcesResponse {
        /** 资源信息 */
        @JsonProperty("resource")
        private List<QueryAlarmBlacklistsReturnObjAlarmBlacklistsResourcesResourceResponse>
                resource;

        public List<QueryAlarmBlacklistsReturnObjAlarmBlacklistsResourcesResourceResponse>
                getResource() {
            return this.resource;
        }

        public void setResource(
                List<QueryAlarmBlacklistsReturnObjAlarmBlacklistsResourcesResourceResponse>
                        resource) {
            this.resource = resource;
        }
    }

    public static class QueryAlarmBlacklistsReturnObjAlarmBlacklistsResourcesResourceResponse {
        /** 资源实例标签键 */
        @JsonProperty("name")
        private String name;

        /** 资源实例标签值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
