package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 根据筛选项查询告警规则列表。 */
public class MonitorQueryAlarmRulesVdaApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryAlarmRulesVdaApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4.1/monitor/query-alarm-rules",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryAlarmRulesVdaResponse send(Credential credential, QueryAlarmRulesVdaRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.service != null) {
            ctReq.addParam("service", request.service);
            request.service = null;
        }
        if (request.alarmStatus != null) {
            ctReq.addParam("alarmStatus", String.valueOf(request.alarmStatus));
            request.alarmStatus = null;
        }
        if (request.status != null) {
            ctReq.addParam("status", String.valueOf(request.status));
            request.status = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.contactGroupName != null) {
            ctReq.addParam("contactGroupName", request.contactGroupName);
            request.contactGroupName = null;
        }
        if (request.instanceName != null) {
            ctReq.addParam("instanceName", request.instanceName);
            request.instanceName = null;
        }
        if (request.sortKey != null) {
            ctReq.addParam("sortKey", request.sortKey);
            request.sortKey = null;
        }
        if (request.sortType != null) {
            ctReq.addParam("sortType", request.sortType);
            request.sortType = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.resGroupID != null) {
            ctReq.addParam("resGroupID", request.resGroupID);
            request.resGroupID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryAlarmRulesVdaResponse.class);
    }

    public static class QueryAlarmRulesVdaRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /**
         * 本参数表示服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警规则是否告警。取值范围：<br>
         * 0：未触发告警。<br>
         * 1：触发告警。<br>
         * 2：无数据。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmStatus")
        private Integer alarmStatus;

        /**
         * 本参数表示告警规则状态。取值范围：<br>
         * 0：启用。<br>
         * 1：停用。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /** 规则名称（模糊查询） */
        @JsonProperty("name")
        private String name;

        /** 告警联系组名（模糊查询） */
        @JsonProperty("contactGroupName")
        private String contactGroupName;

        /** 监控对象名称（模糊查询） */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 排序字段 */
        @JsonProperty("sortKey")
        private String sortKey;

        /**
         * 排序类型。取值范围：<br>
         * ASC：升序。<br>
         * DESC：降序。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("sortType")
        private String sortType;

        /** 页码，默认值：1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 页大小，默认值：20 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 资源分组ID */
        @JsonProperty("resGroupID")
        private String resGroupID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public Integer getAlarmStatus() {
            return this.alarmStatus;
        }

        public void setAlarmStatus(Integer alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getContactGroupName() {
            return this.contactGroupName;
        }

        public void setContactGroupName(String contactGroupName) {
            this.contactGroupName = contactGroupName;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getSortKey() {
            return this.sortKey;
        }

        public void setSortKey(String sortKey) {
            this.sortKey = sortKey;
        }

        public String getSortType() {
            return this.sortType;
        }

        public void setSortType(String sortType) {
            this.sortType = sortType;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getResGroupID() {
            return this.resGroupID;
        }

        public void setResGroupID(String resGroupID) {
            this.resGroupID = resGroupID;
        }
    }

    public static class QueryAlarmRulesVdaResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryAlarmRulesVdaReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public QueryAlarmRulesVdaReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryAlarmRulesVdaReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryAlarmRulesVdaReturnObjResponse {
        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 当前页记录数 */
        @JsonProperty("page")
        private Integer page;

        /** 页大小 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }
}
