package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询指定资源池下告警Top事件。 */
public class MonitorQueryAlarmTopEventApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryAlarmTopEventApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/query-alarm-top-event",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryAlarmTopEventResponse send(Credential credential, QueryAlarmTopEventRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.range != null) {
            ctReq.addParam("range", request.range);
            request.range = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryAlarmTopEventResponse.class);
    }

    public static class QueryAlarmTopEventRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 时间范围，默认值:7d，取值示例：7d，24h，6h 分别代表最近7天，最近24小时，最近6小时。 时间范围最长不能超过3个月 */
        @JsonProperty("range")
        private String range;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }
    }

    public static class QueryAlarmTopEventResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<QueryAlarmTopEventReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public List<QueryAlarmTopEventReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<QueryAlarmTopEventReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryAlarmTopEventReturnObjResponse {
        /** 产品服务 */
        @JsonProperty("service")
        private String service;

        /** 产品维度 */
        @JsonProperty("dimension")
        private String dimension;

        /** 产品服务描述 */
        @JsonProperty("serviceDesc")
        private String serviceDesc;

        /** 产品维度描述 */
        @JsonProperty("dimensionDesc")
        private String dimensionDesc;

        /** 事件 */
        @JsonProperty("event")
        private String event;

        /** 事件描述 */
        @JsonProperty("eventDesc")
        private String eventDesc;

        /** 告警次数 */
        @JsonProperty("count")
        private Integer count;

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getServiceDesc() {
            return this.serviceDesc;
        }

        public void setServiceDesc(String serviceDesc) {
            this.serviceDesc = serviceDesc;
        }

        public String getDimensionDesc() {
            return this.dimensionDesc;
        }

        public void setDimensionDesc(String dimensionDesc) {
            this.dimensionDesc = dimensionDesc;
        }

        public String getEvent() {
            return this.event;
        }

        public void setEvent(String event) {
            this.event = event;
        }

        public String getEventDesc() {
            return this.eventDesc;
        }

        public void setEventDesc(String eventDesc) {
            this.eventDesc = eventDesc;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }
    }
}
