package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询单条告警历史详情。 */
public class MonitorQueryAlertHistoryInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryAlertHistoryInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/query-alert-history-info",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryAlertHistoryInfoResponse send(
            Credential credential, QueryAlertHistoryInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.issueID != null) {
            ctReq.addParam("issueID", request.issueID);
            request.issueID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryAlertHistoryInfoResponse.class);
    }

    public static class QueryAlertHistoryInfoRequest {
        /** 告警历史ID */
        @JsonProperty("issueID")
        private String issueID;

        public String getIssueID() {
            return this.issueID;
        }

        public void setIssueID(String issueID) {
            this.issueID = issueID;
        }
    }

    public static class QueryAlertHistoryInfoResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryAlertHistoryInfoReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryAlertHistoryInfoReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryAlertHistoryInfoReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryAlertHistoryInfoReturnObjResponse {
        /**
         * 本参数表示告警状态。取值范围：<br>
         * 0：正在告警。<br>
         * 1：告警历史。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 本参数表示告警类型。取值范围：<br>
         * series：指标类型。<br>
         * event：事件类型。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmType")
        private String alarmType;

        /** 告警详情ID */
        @JsonProperty("infoID")
        private String infoID;

        /**
         * 本参数表示服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见“[告警规则：获取告警服务列表](https://www.ctyun.cn/document/10032263/10040008)”接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警维度。取值范围：<br>
         * ecs：云主机。<br>
         * disk：磁盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见“[告警规则：获取告警服务维度关系](https://www.ctyun.cn/document/10032263/10040009)”接口返回。
         */
        @JsonProperty("dimension")
        private String dimension;

        /** 告警资源 */
        @JsonProperty("resource")
        private List<QueryAlertHistoryInfoReturnObjResourceResponse> resource;

        /** 告警规则 */
        @JsonProperty("condition")
        private QueryAlertHistoryInfoReturnObjConditionResponse condition;

        /** 资源告警出现次数 */
        @JsonProperty("count")
        private Integer count;

        /** 告警数据值 */
        @JsonProperty("value")
        private Double value;

        /** 触发时间的时间戳 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 结束时间的时间戳。 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getAlarmType() {
            return this.alarmType;
        }

        public void setAlarmType(String alarmType) {
            this.alarmType = alarmType;
        }

        public String getInfoID() {
            return this.infoID;
        }

        public void setInfoID(String infoID) {
            this.infoID = infoID;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public List<QueryAlertHistoryInfoReturnObjResourceResponse> getResource() {
            return this.resource;
        }

        public void setResource(List<QueryAlertHistoryInfoReturnObjResourceResponse> resource) {
            this.resource = resource;
        }

        public QueryAlertHistoryInfoReturnObjConditionResponse getCondition() {
            return this.condition;
        }

        public void setCondition(QueryAlertHistoryInfoReturnObjConditionResponse condition) {
            this.condition = condition;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }
    }

    public static class QueryAlertHistoryInfoReturnObjResourceResponse {
        /** 监控指标 */
        @JsonProperty("name")
        private String name;

        /** 监控指标中文描述 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class QueryAlertHistoryInfoReturnObjConditionResponse {
        /** 监控指标 */
        @JsonProperty("metric")
        private String metric;

        /** 监控指标中文描述 */
        @JsonProperty("metricCnName")
        private String metricCnName;

        /**
         * 本参数表示告警采用算法。取值范围：<br>
         * last：原始值算法。<br>
         * avg：平均值算法。<br>
         * max：最大值算法。<br>
         * min：最小值算法。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("fun")
        private String fun;

        /**
         * 本参数表示比较符。默认值le。取值范围：<br>
         * eq：等于。<br>
         * gt：大于。<br>
         * ge：大于等于。<br>
         * lt：小于。<br>
         * le：小于等于。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("operator")
        private String operator;

        /**
         * 本参数表示算法统计周期。默认值5m。<br>
         * 参数fun为last时不可传。<br>
         * 参数fun为avg、max、min均需填此参数。<br>
         * 本参数格式为“数字+单位”。单位取值范围：<br>
         * m：分钟。<br>
         * h：小时。<br>
         * d：天。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("period")
        private String period;

        /** 告警阈值，可以是整数、小数或百分数格式字符串 */
        @JsonProperty("threshold")
        private String threshold;

        /** 单位。 */
        @JsonProperty("unit")
        private String unit;

        public String getMetric() {
            return this.metric;
        }

        public void setMetric(String metric) {
            this.metric = metric;
        }

        public String getMetricCnName() {
            return this.metricCnName;
        }

        public void setMetricCnName(String metricCnName) {
            this.metricCnName = metricCnName;
        }

        public String getFun() {
            return this.fun;
        }

        public void setFun(String fun) {
            this.fun = fun;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public String getThreshold() {
            return this.threshold;
        }

        public void setThreshold(String threshold) {
            this.threshold = threshold;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }
    }
}
