package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询告警历史, 返回结果按告警历史的触发时间(createTime)降序排列。 */
public class MonitorQueryAlertHistoryListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryAlertHistoryListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/query-alert-history",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryAlertHistoryListResponse send(
            Credential credential, QueryAlertHistoryListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryAlertHistoryListResponse.class);
    }

    public static class QueryAlertHistoryListRequest {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /**
         * 本参数表示状态。取值范围：<br>
         * 0：正在告警。<br>
         * 1：告警历史。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /** 资源分组ID。 */
        @JsonProperty("resourceGroupID")
        private String resourceGroupID;

        /**
         * 本参数表示搜索关键词。取值范围：<br>
         * alarmRuleID：告警规则ID，精确查询。<br>
         * name：告警规则名称，模糊查询。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("searchKey")
        private String searchKey;

        /** 配合searchKey使用，对应的值 */
        @JsonProperty("searchValue")
        private String searchValue;

        /**
         * 本参数表示告警服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("service")
        private List<String> service;

        /** 查询状态为告警历史（参数status=1）时的起始时间戳， 默认值：24小时前时间戳，startTime和endTime需同时传或同时不传 */
        @JsonProperty("startTime")
        private Integer startTime;

        /** 查询状态为告警历史（参数status=1）时的结束时间戳，默认值：当前时间戳， 配合startTime一起使用 */
        @JsonProperty("endTime")
        private Integer endTime;

        /** 页码，默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 页码，默认为1，建议使用pageNo，该参数后续会下线 */
        @JsonProperty("page")
        private Integer page;

        /** 页大小，默认为10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getResourceGroupID() {
            return this.resourceGroupID;
        }

        public void setResourceGroupID(String resourceGroupID) {
            this.resourceGroupID = resourceGroupID;
        }

        public String getSearchKey() {
            return this.searchKey;
        }

        public void setSearchKey(String searchKey) {
            this.searchKey = searchKey;
        }

        public String getSearchValue() {
            return this.searchValue;
        }

        public void setSearchValue(String searchValue) {
            this.searchValue = searchValue;
        }

        public List<String> getService() {
            return this.service;
        }

        public void setService(List<String> service) {
            this.service = service;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Integer endTime) {
            this.endTime = endTime;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryAlertHistoryListResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryAlertHistoryListReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryAlertHistoryListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryAlertHistoryListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryAlertHistoryListReturnObjResponse {
        /** 告警事件列表 */
        @JsonProperty("issues")
        private List<QueryAlertHistoryListReturnObjIssuesResponse> issues;

        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 当前页记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 页码 */
        @JsonProperty("page")
        private Integer page;

        /** 页大小 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public List<QueryAlertHistoryListReturnObjIssuesResponse> getIssues() {
            return this.issues;
        }

        public void setIssues(List<QueryAlertHistoryListReturnObjIssuesResponse> issues) {
            this.issues = issues;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class QueryAlertHistoryListReturnObjIssuesResponse {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 告警历史ID */
        @JsonProperty("issueID")
        private String issueID;

        /** 告警规则ID */
        @JsonProperty("alarmRuleID")
        private String alarmRuleID;

        /** 告警规则名称 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示告警状态。取值范围：<br>
         * 0：正在告警。<br>
         * 1：告警历史。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 本参数表示正在告警下的状态细分。取值范围：<br>
         * 0：有数据。<br>
         * 1：无数据。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("dataStatus")
        private Integer dataStatus;

        /**
         * 本参数表示告警历史下的状态细分。取值范围：<br>
         * 0：正常历史告警。<br>
         * 1：已失效（告警规则已删除或已禁用）<br>
         * 根据以上范围取值。
         */
        @JsonProperty("expiredStatus")
        private Integer expiredStatus;

        /**
         * 本参数表示告警类型。取值范围：<br>
         * series：指标类型。<br>
         * event：事件类型。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmType")
        private String alarmType;

        /** 服务 */
        @JsonProperty("service")
        private String service;

        /** 维度 */
        @JsonProperty("dimension")
        private String dimension;

        /**
         * 本参数表示告警接收策略。取值范围：<br>
         * email：邮件告警。<br>
         * sms：短信告警。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notifyType")
        private List<String> notifyType;

        /** 持续时间，单位秒 */
        @JsonProperty("duration")
        private Integer duration;

        /** 所属组信息 */
        @JsonProperty("contactGroupList")
        private List<QueryAlertHistoryListReturnObjIssuesContactGroupListResponse> contactGroupList;

        /** 触发时间的时间戳 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 更新时间的时间戳 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        /** 资源分组ID */
        @JsonProperty("resGroupID")
        private String resGroupID;

        /** 资源分组名称 */
        @JsonProperty("resGroupName")
        private String resGroupName;

        /** 告警资源 */
        @JsonProperty("resources")
        private List<QueryAlertHistoryListReturnObjIssuesResourcesResponse> resources;

        /**
         * 是否使用天翼云默认联系人发送通知。默认值：0<br>
         * 0：否<br>
         * 1：是
         */
        @JsonProperty("defaultContact")
        private Integer defaultContact;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getIssueID() {
            return this.issueID;
        }

        public void setIssueID(String issueID) {
            this.issueID = issueID;
        }

        public String getAlarmRuleID() {
            return this.alarmRuleID;
        }

        public void setAlarmRuleID(String alarmRuleID) {
            this.alarmRuleID = alarmRuleID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getDataStatus() {
            return this.dataStatus;
        }

        public void setDataStatus(Integer dataStatus) {
            this.dataStatus = dataStatus;
        }

        public Integer getExpiredStatus() {
            return this.expiredStatus;
        }

        public void setExpiredStatus(Integer expiredStatus) {
            this.expiredStatus = expiredStatus;
        }

        public String getAlarmType() {
            return this.alarmType;
        }

        public void setAlarmType(String alarmType) {
            this.alarmType = alarmType;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public List<String> getNotifyType() {
            return this.notifyType;
        }

        public void setNotifyType(List<String> notifyType) {
            this.notifyType = notifyType;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public void setDuration(Integer duration) {
            this.duration = duration;
        }

        public List<QueryAlertHistoryListReturnObjIssuesContactGroupListResponse>
                getContactGroupList() {
            return this.contactGroupList;
        }

        public void setContactGroupList(
                List<QueryAlertHistoryListReturnObjIssuesContactGroupListResponse>
                        contactGroupList) {
            this.contactGroupList = contactGroupList;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }

        public String getResGroupID() {
            return this.resGroupID;
        }

        public void setResGroupID(String resGroupID) {
            this.resGroupID = resGroupID;
        }

        public String getResGroupName() {
            return this.resGroupName;
        }

        public void setResGroupName(String resGroupName) {
            this.resGroupName = resGroupName;
        }

        public List<QueryAlertHistoryListReturnObjIssuesResourcesResponse> getResources() {
            return this.resources;
        }

        public void setResources(
                List<QueryAlertHistoryListReturnObjIssuesResourcesResponse> resources) {
            this.resources = resources;
        }

        public Integer getDefaultContact() {
            return this.defaultContact;
        }

        public void setDefaultContact(Integer defaultContact) {
            this.defaultContact = defaultContact;
        }
    }

    public static class QueryAlertHistoryListReturnObjIssuesContactGroupListResponse {
        /** 联系人组ID */
        @JsonProperty("contactGroupID")
        private String contactGroupID;

        /** 联系人组名称 */
        @JsonProperty("name")
        private String name;

        public String getContactGroupID() {
            return this.contactGroupID;
        }

        public void setContactGroupID(String contactGroupID) {
            this.contactGroupID = contactGroupID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class QueryAlertHistoryListReturnObjIssuesResourcesResponse {
        /** 资源实例标签键 */
        @JsonProperty("name")
        private String name;

        /** 资源实例标签值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
