package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 此接口用于获取一键报警支持的产品及规则初始化信息。 */
public class MonitorQueryAlertOnekeyServicesViewApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryAlertOnekeyServicesViewApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/alert-onekey/describe-services",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryAlertOnekeyServicesViewResponse send(
            Credential credential, QueryAlertOnekeyServicesViewRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryAlertOnekeyServicesViewResponse.class);
    }

    public static class QueryAlertOnekeyServicesViewRequest {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }
    }

    public static class QueryAlertOnekeyServicesViewResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private QueryAlertOnekeyServicesViewReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryAlertOnekeyServicesViewReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryAlertOnekeyServicesViewReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryAlertOnekeyServicesViewReturnObjResponse {
        /** 初始化规则列表 */
        @JsonProperty("alertInitConfigList")
        private List<QueryAlertOnekeyServicesViewReturnObjAlertInitConfigListResponse>
                alertInitConfigList;

        /**
         * 服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * ...<br>
         * 详见“[一键报警：产品列表]”接口返回。
         */
        @JsonProperty("service")
        private String service;

        public List<QueryAlertOnekeyServicesViewReturnObjAlertInitConfigListResponse>
                getAlertInitConfigList() {
            return this.alertInitConfigList;
        }

        public void setAlertInitConfigList(
                List<QueryAlertOnekeyServicesViewReturnObjAlertInitConfigListResponse>
                        alertInitConfigList) {
            this.alertInitConfigList = alertInitConfigList;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }
    }

    public static class QueryAlertOnekeyServicesViewReturnObjAlertInitConfigListResponse {
        /**
         * 维度。值范围：<br>
         * ecs：云主机。<br>
         * disk：磁盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见“[告警规则：获取告警服务维度关系](https://www.ctyun.cn/document/10032263/10040009)”接口返回。
         */
        @JsonProperty("dimension")
        private String dimension;

        /** 规则名 */
        @JsonProperty("name")
        private String name;

        /** 指标名 */
        @JsonProperty("metric")
        private String metric;

        /** 连续出现次数 */
        @JsonProperty("evaluationCount")
        private Integer evaluationCount;

        /**
         * 注意：一键报警规则的告警类型（alarmType）为事件类型（event）时，没有此返回参数。<br>
         * 此参数表示比较符：<br>
         * eq：等于。<br>
         * gt：大于。<br>
         * ge：大于等于。<br>
         * lt：小于。<br>
         * le：小于等于 。
         */
        @JsonProperty("operator")
        private String operator;

        /**
         * 注意：一键报警规则的告警类型（alarmType）为事件类型（event）时，没有此返回参数。<br>
         * 此参数表示告警阈值，可以是整数、小数或百分数格式字符串
         */
        @JsonProperty("value")
        private String value;

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMetric() {
            return this.metric;
        }

        public void setMetric(String metric) {
            this.metric = metric;
        }

        public Integer getEvaluationCount() {
            return this.evaluationCount;
        }

        public void setEvaluationCount(Integer evaluationCount) {
            this.evaluationCount = evaluationCount;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
