package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询告警历史告警数TOP细分图表。 */
public class MonitorQueryAlertTopOverviewApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryAlertTopOverviewApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/query-alert-top-overview",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryAlertTopOverviewResponse send(
            Credential credential, QueryAlertTopOverviewRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryAlertTopOverviewResponse.class);
    }

    public static class QueryAlertTopOverviewRequest {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 查询起始时间戳 */
        @JsonProperty("startTime")
        private Integer startTime;

        /** 查询结束时间戳 */
        @JsonProperty("endTime")
        private Integer endTime;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Integer endTime) {
            this.endTime = endTime;
        }
    }

    public static class QueryAlertTopOverviewResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryAlertTopOverviewReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryAlertTopOverviewReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryAlertTopOverviewReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryAlertTopOverviewReturnObjResponse {
        /** 告警数Top10产品 */
        @JsonProperty("products")
        private List<QueryAlertTopOverviewReturnObjProductsResponse> products;

        /** 告警数Top10指标 */
        @JsonProperty("metrics")
        private List<QueryAlertTopOverviewReturnObjMetricsResponse> metrics;

        /** 告警数Top10实例 */
        @JsonProperty("devices")
        private List<QueryAlertTopOverviewReturnObjDevicesResponse> devices;

        public List<QueryAlertTopOverviewReturnObjProductsResponse> getProducts() {
            return this.products;
        }

        public void setProducts(List<QueryAlertTopOverviewReturnObjProductsResponse> products) {
            this.products = products;
        }

        public List<QueryAlertTopOverviewReturnObjMetricsResponse> getMetrics() {
            return this.metrics;
        }

        public void setMetrics(List<QueryAlertTopOverviewReturnObjMetricsResponse> metrics) {
            this.metrics = metrics;
        }

        public List<QueryAlertTopOverviewReturnObjDevicesResponse> getDevices() {
            return this.devices;
        }

        public void setDevices(List<QueryAlertTopOverviewReturnObjDevicesResponse> devices) {
            this.devices = devices;
        }
    }

    public static class QueryAlertTopOverviewReturnObjProductsResponse {
        /** 产品纬度名称 */
        @JsonProperty("name")
        private String name;

        /** 数量 */
        @JsonProperty("value")
        private Integer value;

        /** 描述 */
        @JsonProperty("desc")
        private String desc;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public static class QueryAlertTopOverviewReturnObjMetricsResponse {
        /** 监控指标名称 */
        @JsonProperty("name")
        private String name;

        /** 数量 */
        @JsonProperty("value")
        private Integer value;

        /** 描述 */
        @JsonProperty("desc")
        private String desc;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public static class QueryAlertTopOverviewReturnObjDevicesResponse {
        /** 实例 */
        @JsonProperty("name")
        private String name;

        /** 数量 */
        @JsonProperty("value")
        private Integer value;

        /** 描述 */
        @JsonProperty("desc")
        private String desc;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}
