package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 根据筛选项查询自定义监控告警规则列表。 */
public class MonitorQueryCustomAlarmRulesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryCustomAlarmRulesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/query-custom-alarm-rules",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryCustomAlarmRulesResponse send(
            Credential credential, QueryCustomAlarmRulesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.status != null) {
            ctReq.addParam("status", String.valueOf(request.status));
            request.status = null;
        }
        if (request.alarmStatus != null) {
            ctReq.addParam("alarmStatus", String.valueOf(request.alarmStatus));
            request.alarmStatus = null;
        }
        if (request.sort != null) {
            ctReq.addParam("sort", request.sort);
            request.sort = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryCustomAlarmRulesResponse.class);
    }

    public static class QueryCustomAlarmRulesRequest {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /**
         * 本参数表示告警规则启用状态。取值范围：<br>
         * 0：启用。<br>
         * 1：停用。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 本参数表示告警规则告警状态。取值范围：<br>
         * 0：正常。<br>
         * 1：正在告警。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmStatus")
        private Integer alarmStatus;

        /**
         * 本参数表示排序条件，-表示降序。支持的排序字段：<br>
         * updateTime：更新时间。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("sort")
        private String sort;

        /** 规则名称 */
        @JsonProperty("name")
        private String name;

        /** 页码，默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 页大小，默认为20 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getAlarmStatus() {
            return this.alarmStatus;
        }

        public void setAlarmStatus(Integer alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        public String getSort() {
            return this.sort;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryCustomAlarmRulesResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryCustomAlarmRulesReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryCustomAlarmRulesReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryCustomAlarmRulesReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryCustomAlarmRulesReturnObjResponse {
        /** 告警规则 */
        @JsonProperty("alarmRules")
        private List<QueryCustomAlarmRulesReturnObjAlarmRulesResponse> alarmRules;

        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 当前页记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public List<QueryCustomAlarmRulesReturnObjAlarmRulesResponse> getAlarmRules() {
            return this.alarmRules;
        }

        public void setAlarmRules(
                List<QueryCustomAlarmRulesReturnObjAlarmRulesResponse> alarmRules) {
            this.alarmRules = alarmRules;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class QueryCustomAlarmRulesReturnObjAlarmRulesResponse {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 告警规则ID */
        @JsonProperty("alarmRuleID")
        private String alarmRuleID;

        /** 规则名 */
        @JsonProperty("name")
        private String name;

        /** 描述 */
        @JsonProperty("desc")
        private String desc;

        /** 重复告警通知次数 */
        @JsonProperty("repeatTimes")
        private Integer repeatTimes;

        /** 静默时间，单位：秒 */
        @JsonProperty("silenceTime")
        private Integer silenceTime;

        /**
         * 本参数表示恢复是否通知。默认值0。取值范围：<br>
         * 0：否。<br>
         * 1：是。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("recoverNotify")
        private Integer recoverNotify;

        /** 告警接收策略 */
        @JsonProperty("notifyType")
        private List<String> notifyType;

        /** 告警联系人组 */
        @JsonProperty("contactGroupList")
        private List<String> contactGroupList;

        /** 通知周期 */
        @JsonProperty("notifyWeekdays")
        private List<Integer> notifyWeekdays;

        /** 通知起始时段 */
        @JsonProperty("notifyStart")
        private String notifyStart;

        /** 通知结束时段 */
        @JsonProperty("notifyEnd")
        private String notifyEnd;

        /** 持续周期数 */
        @JsonProperty("evaluationCount")
        private Integer evaluationCount;

        /** 自定义监控指标 */
        @JsonProperty("customItemID")
        private String customItemID;

        /**
         * 本参数表示告警采用算法。取值范围：<br>
         * last：原始值算法。<br>
         * avg：平均值算法。<br>
         * max：最大值算法。<br>
         * min：最小值算法。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("fun")
        private String fun;

        /**
         * 本参数表示比较符。默认值le。取值范围：<br>
         * eq：等于。<br>
         * gt：大于。<br>
         * ge：大于等于。<br>
         * lt：小于。<br>
         * le：小于等于。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("operator")
        private String operator;

        /** 告警阈值，可以是整数、小数或百分数格式字符串 */
        @JsonProperty("value")
        private String value;

        /**
         * 本参数表示算法统计周期。默认值5m。<br>
         * 参数fun为last时不可传。<br>
         * 参数fun为avg、max、min均需填此参数。<br>
         * 本参数格式为“数字+单位”。单位取值范围：<br>
         * m：分钟。<br>
         * h：小时。<br>
         * d：天。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("period")
        private String period;

        /**
         * 本参数表示告警规则启用状态。取值范围：<br>
         * 0：启用。<br>
         * 1：停用。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 本参数表示告警规则告警状态。取值范围：<br>
         * 0：正常。<br>
         * 1：正在告警。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmStatus")
        private Integer alarmStatus;

        /** 创建时间 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 更新时间 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getAlarmRuleID() {
            return this.alarmRuleID;
        }

        public void setAlarmRuleID(String alarmRuleID) {
            this.alarmRuleID = alarmRuleID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public Integer getRepeatTimes() {
            return this.repeatTimes;
        }

        public void setRepeatTimes(Integer repeatTimes) {
            this.repeatTimes = repeatTimes;
        }

        public Integer getSilenceTime() {
            return this.silenceTime;
        }

        public void setSilenceTime(Integer silenceTime) {
            this.silenceTime = silenceTime;
        }

        public Integer getRecoverNotify() {
            return this.recoverNotify;
        }

        public void setRecoverNotify(Integer recoverNotify) {
            this.recoverNotify = recoverNotify;
        }

        public List<String> getNotifyType() {
            return this.notifyType;
        }

        public void setNotifyType(List<String> notifyType) {
            this.notifyType = notifyType;
        }

        public List<String> getContactGroupList() {
            return this.contactGroupList;
        }

        public void setContactGroupList(List<String> contactGroupList) {
            this.contactGroupList = contactGroupList;
        }

        public List<Integer> getNotifyWeekdays() {
            return this.notifyWeekdays;
        }

        public void setNotifyWeekdays(List<Integer> notifyWeekdays) {
            this.notifyWeekdays = notifyWeekdays;
        }

        public String getNotifyStart() {
            return this.notifyStart;
        }

        public void setNotifyStart(String notifyStart) {
            this.notifyStart = notifyStart;
        }

        public String getNotifyEnd() {
            return this.notifyEnd;
        }

        public void setNotifyEnd(String notifyEnd) {
            this.notifyEnd = notifyEnd;
        }

        public Integer getEvaluationCount() {
            return this.evaluationCount;
        }

        public void setEvaluationCount(Integer evaluationCount) {
            this.evaluationCount = evaluationCount;
        }

        public String getCustomItemID() {
            return this.customItemID;
        }

        public void setCustomItemID(String customItemID) {
            this.customItemID = customItemID;
        }

        public String getFun() {
            return this.fun;
        }

        public void setFun(String fun) {
            this.fun = fun;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getAlarmStatus() {
            return this.alarmStatus;
        }

        public void setAlarmStatus(Integer alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }
    }
}
