package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询指定自定义监控的时序指标趋势监控数据。 */
public class MonitorQueryCustomItemTrendmetricdataApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryCustomItemTrendmetricdataApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/query-custom-item-trendmetricdata",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryCustomItemTrendmetricdataResponse send(
            Credential credential, QueryCustomItemTrendmetricdataRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryCustomItemTrendmetricdataResponse.class);
    }

    public static class QueryCustomItemTrendmetricdataRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 自定义监控项ID */
        @JsonProperty("customItemID")
        private String customItemID;

        /** 查询起始时间戳 */
        @JsonProperty("startTime")
        private String startTime;

        /** 查询结束时间戳 */
        @JsonProperty("endTime")
        private String endTime;

        /** 聚合周期，单位：秒，默认300 */
        @JsonProperty("period")
        private Integer period;

        /** 自定义监控项维度 */
        @JsonProperty("dimensions")
        private List<QueryCustomItemTrendmetricdataDimensionsRequest> dimensions;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getCustomItemID() {
            return this.customItemID;
        }

        public void setCustomItemID(String customItemID) {
            this.customItemID = customItemID;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }

        public List<QueryCustomItemTrendmetricdataDimensionsRequest> getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(
                List<QueryCustomItemTrendmetricdataDimensionsRequest> dimensions) {
            this.dimensions = dimensions;
        }
    }

    public static class QueryCustomItemTrendmetricdataDimensionsRequest {
        /** 维度名称 */
        @JsonProperty("name")
        private String name;

        /** 维度值 */
        @JsonProperty("value")
        private List<String> value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getValue() {
            return this.value;
        }

        public void setValue(List<String> value) {
            this.value = value;
        }
    }

    public static class QueryCustomItemTrendmetricdataResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryCustomItemTrendmetricdataReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryCustomItemTrendmetricdataReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryCustomItemTrendmetricdataReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryCustomItemTrendmetricdataReturnObjResponse {
        /** 返回数据结果 */
        @JsonProperty("result")
        private List<QueryCustomItemTrendmetricdataReturnObjResultResponse> result;

        public List<QueryCustomItemTrendmetricdataReturnObjResultResponse> getResult() {
            return this.result;
        }

        public void setResult(List<QueryCustomItemTrendmetricdataReturnObjResultResponse> result) {
            this.result = result;
        }
    }

    public static class QueryCustomItemTrendmetricdataReturnObjResultResponse {
        /** 所属资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 自定义监控项ID */
        @JsonProperty("customItemID")
        private String customItemID;

        /** 监控项值列表 */
        @JsonProperty("data")
        private List<QueryCustomItemTrendmetricdataReturnObjResultDataResponse> data;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getCustomItemID() {
            return this.customItemID;
        }

        public void setCustomItemID(String customItemID) {
            this.customItemID = customItemID;
        }

        public List<QueryCustomItemTrendmetricdataReturnObjResultDataResponse> getData() {
            return this.data;
        }

        public void setData(List<QueryCustomItemTrendmetricdataReturnObjResultDataResponse> data) {
            this.data = data;
        }
    }

    public static class QueryCustomItemTrendmetricdataReturnObjResultDataResponse {
        /** 监控数据采样时间 */
        @JsonProperty("samplingTime")
        private Integer samplingTime;

        /** 监控项最大值 */
        @JsonProperty("max")
        private Double max;

        /** 监控项最小值 */
        @JsonProperty("min")
        private Double min;

        /** 监控项平均值 */
        @JsonProperty("avg")
        private Double avg;

        /** 监控项方差 */
        @JsonProperty("variance")
        private Double variance;

        public Integer getSamplingTime() {
            return this.samplingTime;
        }

        public void setSamplingTime(Integer samplingTime) {
            this.samplingTime = samplingTime;
        }

        public Double getMax() {
            return this.max;
        }

        public void setMax(Double max) {
            this.max = max;
        }

        public Double getMin() {
            return this.min;
        }

        public void setMin(Double min) {
            this.min = min;
        }

        public Double getAvg() {
            return this.avg;
        }

        public void setAvg(Double avg) {
            this.avg = avg;
        }

        public Double getVariance() {
            return this.variance;
        }

        public void setVariance(Double variance) {
            this.variance = variance;
        }
    }
}
