package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询自定义监控项。 */
public class MonitorQueryCustomItemsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryCustomItemsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/monitor/query-custom-items", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryCustomItemsResponse send(Credential credential, QueryCustomItemsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.customItemID != null) {
            ctReq.addParam("customItemID", request.customItemID);
            request.customItemID = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryCustomItemsResponse.class);
    }

    public static class QueryCustomItemsRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 自定义监控项ID */
        @JsonProperty("customItemID")
        private String customItemID;

        /** 监控项名称，支持模糊搜索 */
        @JsonProperty("name")
        private String name;

        /** 页码，不传默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 每页大小，不传默认为10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getCustomItemID() {
            return this.customItemID;
        }

        public void setCustomItemID(String customItemID) {
            this.customItemID = customItemID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryCustomItemsResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private QueryCustomItemsReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryCustomItemsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryCustomItemsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryCustomItemsReturnObjResponse {
        /** 自定义监控项列表 */
        @JsonProperty("customItemList")
        private List<QueryCustomItemsReturnObjCustomItemListResponse> customItemList;

        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        /** 当前记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        public List<QueryCustomItemsReturnObjCustomItemListResponse> getCustomItemList() {
            return this.customItemList;
        }

        public void setCustomItemList(
                List<QueryCustomItemsReturnObjCustomItemListResponse> customItemList) {
            this.customItemList = customItemList;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }
    }

    public static class QueryCustomItemsReturnObjCustomItemListResponse {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 自定义监控项ID */
        @JsonProperty("customItemID")
        private String customItemID;

        /** 监控项名称 */
        @JsonProperty("name")
        private String name;

        /** 自定义监控项的单位 */
        @JsonProperty("unit")
        private String unit;

        /** 数据上报间隔，单位秒 */
        @JsonProperty("interval")
        private Integer interval;

        /** 用于查询监控数据的维度 */
        @JsonProperty("dimensions")
        private List<String> dimensions;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getCustomItemID() {
            return this.customItemID;
        }

        public void setCustomItemID(String customItemID) {
            this.customItemID = customItemID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public Integer getInterval() {
            return this.interval;
        }

        public void setInterval(Integer interval) {
            this.interval = interval;
        }

        public List<String> getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(List<String> dimensions) {
            this.dimensions = dimensions;
        }
    }
}
