package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询数据导出任务结果。 */
public class MonitorQueryDataExportTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryDataExportTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/task-center/query-task",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryDataExportTaskResponse send(
            Credential credential, QueryDataExportTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.taskID != null) {
            ctReq.addParam("taskID", request.taskID);
            request.taskID = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryDataExportTaskResponse.class);
    }

    public static class QueryDataExportTaskRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 任务ID */
        @JsonProperty("taskID")
        private String taskID;

        /** 任务名称，支持模糊搜索 */
        @JsonProperty("name")
        private String name;

        /** 页码，不传默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 每页大小，不传默认为20 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getTaskID() {
            return this.taskID;
        }

        public void setTaskID(String taskID) {
            this.taskID = taskID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryDataExportTaskResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private QueryDataExportTaskReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryDataExportTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryDataExportTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryDataExportTaskReturnObjResponse {
        /** 任务列表 */
        @JsonProperty("taskList")
        private List<QueryDataExportTaskReturnObjTaskListResponse> taskList;

        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        /** 当前记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        public List<QueryDataExportTaskReturnObjTaskListResponse> getTaskList() {
            return this.taskList;
        }

        public void setTaskList(List<QueryDataExportTaskReturnObjTaskListResponse> taskList) {
            this.taskList = taskList;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }
    }

    public static class QueryDataExportTaskReturnObjTaskListResponse {
        /** 任务名称 */
        @JsonProperty("name")
        private String name;

        /** 任务描述 */
        @JsonProperty("description")
        private String description;

        /**
         * 本参数表示设备类型。取值范围：<br>
         * vm：云主机。<br>
         * disk：云磁盘。<br>
         * traffic：共享带宽。<br>
         * eip：弹性IP。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("deviceType")
        private String deviceType;

        /** 设备列表，为空代表该资源池下用户所有该类型设备列表 */
        @JsonProperty("deviceUUIDList")
        private List<String> deviceUUIDList;

        /** 待查的监控项名称，具体设备对应监控项参见[监控项列表：查询](https://www.ctyun.cn/document/10032263/10039882) */
        @JsonProperty("itemNameList")
        private List<String> itemNameList;

        /**
         * 本参数表示数据聚合类型。取值范围：<br>
         * raw：原始值。<br>
         * avg：平均值。<br>
         * max：最大值。<br>
         * min：最小值。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("aggregateType")
        private List<String> aggregateType;

        /** 数据起始时间 */
        @JsonProperty("startTime")
        private Integer startTime;

        /** 数据截止时间 */
        @JsonProperty("endTime")
        private Integer endTime;

        /** 数据点间隔 */
        @JsonProperty("period")
        private Integer period;

        /** 创建时间,精确至毫秒 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 更新时间,精确至毫秒 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        /**
         * 本参数表示任务状态码。取值范围：<br>
         * 0：待处理。<br>
         * 1：处理中。<br>
         * 2：已完成。<br>
         * 3：失败。<br>
         * 4：过期。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /** 百分比进度，当status为1时有意义，范围 0-100 */
        @JsonProperty("process")
        private Integer process;

        /** 任务详情，可用于展示报错信息 */
        @JsonProperty("msg")
        private String msg;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDeviceType() {
            return this.deviceType;
        }

        public void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public List<String> getDeviceUUIDList() {
            return this.deviceUUIDList;
        }

        public void setDeviceUUIDList(List<String> deviceUUIDList) {
            this.deviceUUIDList = deviceUUIDList;
        }

        public List<String> getItemNameList() {
            return this.itemNameList;
        }

        public void setItemNameList(List<String> itemNameList) {
            this.itemNameList = itemNameList;
        }

        public List<String> getAggregateType() {
            return this.aggregateType;
        }

        public void setAggregateType(List<String> aggregateType) {
            this.aggregateType = aggregateType;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Integer endTime) {
            this.endTime = endTime;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getProcess() {
            return this.process;
        }

        public void setProcess(Integer process) {
            this.process = process;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}
