package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询拨测点信息。 */
public class MonitorQueryDetectionPointApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryDetectionPointApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/query-detection-point",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryDetectionPointResponse send(
            Credential credential, QueryDetectionPointRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryDetectionPointResponse.class);
    }

    public static class QueryDetectionPointRequest {}

    public static class QueryDetectionPointResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private QueryDetectionPointReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryDetectionPointReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryDetectionPointReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryDetectionPointReturnObjResponse {
        /** 拨测点列表 */
        @JsonProperty("detectionPointList")
        private List<QueryDetectionPointReturnObjDetectionPointListResponse> detectionPointList;

        public List<QueryDetectionPointReturnObjDetectionPointListResponse>
                getDetectionPointList() {
            return this.detectionPointList;
        }

        public void setDetectionPointList(
                List<QueryDetectionPointReturnObjDetectionPointListResponse> detectionPointList) {
            this.detectionPointList = detectionPointList;
        }
    }

    public static class QueryDetectionPointReturnObjDetectionPointListResponse {
        /** 拨测点ID */
        @JsonProperty("pointID")
        private String pointID;

        /** 拨测点名称 */
        @JsonProperty("name")
        private String name;

        /** 拨测点描述 */
        @JsonProperty("description")
        private String description;

        /** 当前是否可用 */
        @JsonProperty("status")
        private Boolean status;

        public String getPointID() {
            return this.pointID;
        }

        public void setPointID(String pointID) {
            this.pointID = pointID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Boolean getStatus() {
            return this.status;
        }

        public void setStatus(Boolean status) {
            this.status = status;
        }
    }
}
