package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 根据指定时间段查询事件发生情况。 */
public class MonitorQueryEventDetailApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryEventDetailApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/events/query-detail",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryEventDetailResponse send(Credential credential, QueryEventDetailRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryEventDetailResponse.class);
    }

    public static class QueryEventDetailRequest {
        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 查询起始时间戳 */
        @JsonProperty("startTime")
        private Integer startTime;

        /** 查询截止时间戳 */
        @JsonProperty("endTime")
        private Integer endTime;

        /** 本参数表示事件指标，事件指标见查询事件接口返回。 */
        @JsonProperty("eventName")
        private String eventName;

        /** 服务，见事件监控：查询服务维度接口返回。 */
        @JsonProperty("service")
        private String service;

        /** 维度，见事件监控：查询服务维度接口返回。 */
        @JsonProperty("dimension")
        private String dimension;

        /** 页码，默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 页大小，默认为20 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Integer endTime) {
            this.endTime = endTime;
        }

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryEventDetailResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryEventDetailReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryEventDetailReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryEventDetailReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryEventDetailReturnObjResponse {
        /** 获取对象数据条数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        /** 当前页记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 事件详情列表 */
        @JsonProperty("eventDetail")
        private List<QueryEventDetailReturnObjEventDetailResponse> eventDetail;

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public List<QueryEventDetailReturnObjEventDetailResponse> getEventDetail() {
            return this.eventDetail;
        }

        public void setEventDetail(List<QueryEventDetailReturnObjEventDetailResponse> eventDetail) {
            this.eventDetail = eventDetail;
        }
    }

    public static class QueryEventDetailReturnObjEventDetailResponse {
        /** 设备ID */
        @JsonProperty("deviceUUID")
        private String deviceUUID;

        /** 设备名称 */
        @JsonProperty("deviceName")
        private String deviceName;

        /** 设备事件发生时间，秒级时间戳 */
        @JsonProperty("deviceTime")
        private Integer deviceTime;

        public String getDeviceUUID() {
            return this.deviceUUID;
        }

        public void setDeviceUUID(String deviceUUID) {
            this.deviceUUID = deviceUUID;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public Integer getDeviceTime() {
            return this.deviceTime;
        }

        public void setDeviceTime(Integer deviceTime) {
            this.deviceTime = deviceTime;
        }
    }
}
