package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取资源池下指定维度下的事件。 */
public class MonitorQueryEventsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryEventsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/events/query-events",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryEventsResponse send(Credential credential, QueryEventsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.service != null) {
            ctReq.addParam("service", request.service);
            request.service = null;
        }
        if (request.dimension != null) {
            ctReq.addParam("dimension", request.dimension);
            request.dimension = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryEventsResponse.class);
    }

    public static class QueryEventsRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 服务，见事件监控：查询服务维度接口返回。 */
        @JsonProperty("service")
        private String service;

        /** 维度，见事件监控：查询服务维度接口返回。 */
        @JsonProperty("dimension")
        private String dimension;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }
    }

    public static class QueryEventsResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryEventsReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryEventsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryEventsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryEventsReturnObjResponse {
        /** 事件列表 */
        @JsonProperty("events")
        private List<QueryEventsReturnObjEventsResponse> events;

        public List<QueryEventsReturnObjEventsResponse> getEvents() {
            return this.events;
        }

        public void setEvents(List<QueryEventsReturnObjEventsResponse> events) {
            this.events = events;
        }
    }

    public static class QueryEventsReturnObjEventsResponse {
        /** 事件指标 */
        @JsonProperty("eventName")
        private String eventName;

        /** 事件中文描述 */
        @JsonProperty("description")
        private String description;

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}
