package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询通知记录列表。 */
public class MonitorQueryMessageRecordsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryMessageRecordsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/query-message-records",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryMessageRecordsResponse send(
            Credential credential, QueryMessageRecordsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.receiver != null) {
            ctReq.addParam("receiver", request.receiver);
            request.receiver = null;
        }
        if (request.recordType != null) {
            ctReq.addParam("recordType", String.valueOf(request.recordType));
            request.recordType = null;
        }
        if (request.method != null) {
            ctReq.addParam("method", request.method);
            request.method = null;
        }
        if (request.recordStatus != null) {
            ctReq.addParam("recordStatus", String.valueOf(request.recordStatus));
            request.recordStatus = null;
        }
        if (request.startTime != null) {
            ctReq.addParam("startTime", String.valueOf(request.startTime));
            request.startTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", String.valueOf(request.endTime));
            request.endTime = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryMessageRecordsResponse.class);
    }

    public static class QueryMessageRecordsRequest {
        /** 通知对象 */
        @JsonProperty("receiver")
        private String receiver;

        /**
         * 本参数表示通知类型。取值范围：<br>
         * 0：监控告警通知。<br>
         * 1：外部告警通知。
         */
        @JsonProperty("recordType")
        private Integer recordType;

        /**
         * 本参数表示通知方式。取值范围：<br>
         * email：邮件。<br>
         * sms：短信。<br>
         * webhook
         */
        @JsonProperty("method")
        private String method;

        /**
         * 本参数表示通知状态。取值范围：<br>
         * 0：通知发送成功。<br>
         * 1：通知发送失败。
         */
        @JsonProperty("recordStatus")
        private Integer recordStatus;

        /** 创建通知起始时间，精确到毫秒 */
        @JsonProperty("startTime")
        private Long startTime;

        /** 创建通知截止时间，精确到毫秒（截止时间与起始时间间隔不超过30天） */
        @JsonProperty("endTime")
        private Long endTime;

        /** 页码，默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 每页大小，默认为20 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getReceiver() {
            return this.receiver;
        }

        public void setReceiver(String receiver) {
            this.receiver = receiver;
        }

        public Integer getRecordType() {
            return this.recordType;
        }

        public void setRecordType(Integer recordType) {
            this.recordType = recordType;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public Integer getRecordStatus() {
            return this.recordStatus;
        }

        public void setRecordStatus(Integer recordStatus) {
            this.recordStatus = recordStatus;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryMessageRecordsResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryMessageRecordsReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryMessageRecordsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryMessageRecordsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryMessageRecordsReturnObjResponse {
        /** 通知记录列表 */
        @JsonProperty("MessageRecords")
        private List<QueryMessageRecordsReturnObjMessageRecordsResponse> messageRecords;

        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 当前页记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public List<QueryMessageRecordsReturnObjMessageRecordsResponse> getMessageRecords() {
            return this.messageRecords;
        }

        public void setMessageRecords(
                List<QueryMessageRecordsReturnObjMessageRecordsResponse> messageRecords) {
            this.messageRecords = messageRecords;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class QueryMessageRecordsReturnObjMessageRecordsResponse {
        /** 通知记录ID */
        @JsonProperty("recordID")
        private String recordID;

        /** 通知对象 */
        @JsonProperty("receiver")
        private String receiver;

        /**
         * 本参数表示通知类型。取值范围：<br>
         * 0：监控告警通知。<br>
         * 1：外部告警通知。
         */
        @JsonProperty("recordType")
        private Integer recordType;

        /**
         * 本参数表示通知方式。取值范围：<br>
         * email：邮件。<br>
         * sms：短信。<br>
         * webhook
         */
        @JsonProperty("method")
        private String method;

        /**
         * 本参数表示通知状态。取值范围：<br>
         * 0：通知发送成功。<br>
         * 1：通知发送失败。
         */
        @JsonProperty("recordStatus")
        private Integer recordStatus;

        /** 通知主题 */
        @JsonProperty("subject")
        private String subject;

        /** 通知内容 */
        @JsonProperty("content")
        private String content;

        /** 通知发送错误信息 */
        @JsonProperty("errMessage")
        private String errMessage;

        /** 创建时间，时间戳，精确到毫秒 */
        @JsonProperty("createTime")
        private Integer createTime;

        public String getRecordID() {
            return this.recordID;
        }

        public void setRecordID(String recordID) {
            this.recordID = recordID;
        }

        public String getReceiver() {
            return this.receiver;
        }

        public void setReceiver(String receiver) {
            this.receiver = receiver;
        }

        public Integer getRecordType() {
            return this.recordType;
        }

        public void setRecordType(Integer recordType) {
            this.recordType = recordType;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public Integer getRecordStatus() {
            return this.recordStatus;
        }

        public void setRecordStatus(Integer recordStatus) {
            this.recordStatus = recordStatus;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getErrMessage() {
            return this.errMessage;
        }

        public void setErrMessage(String errMessage) {
            this.errMessage = errMessage;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }
    }
}
