package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询用户资源分组列表。 */
public class MonitorQueryResGroupsV41Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryResGroupsV41Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4.1/monitor/query-resource-groups",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryResGroupsV41Response send(Credential credential, QueryResGroupsV41Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.resGroupID != null) {
            ctReq.addParam("resGroupID", request.resGroupID);
            request.resGroupID = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryResGroupsV41Response.class);
    }

    public static class QueryResGroupsV41Request {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 名称模糊搜索 */
        @JsonProperty("name")
        private String name;

        /** 资源分组ID搜索 */
        @JsonProperty("resGroupID")
        private String resGroupID;

        /** 页码，默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 每页数量，默认10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getResGroupID() {
            return this.resGroupID;
        }

        public void setResGroupID(String resGroupID) {
            this.resGroupID = resGroupID;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryResGroupsV41Response {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private QueryResGroupsV41ReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryResGroupsV41ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryResGroupsV41ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryResGroupsV41ReturnObjResponse {
        /** 返回用户的资源分组列表 */
        @JsonProperty("resGroupList")
        private List<QueryResGroupsV41ReturnObjResGroupListResponse> resGroupList;

        /** 资源分组配额剩余数量 */
        @JsonProperty("resGroupQuota")
        private Integer resGroupQuota;

        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 当前页记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public List<QueryResGroupsV41ReturnObjResGroupListResponse> getResGroupList() {
            return this.resGroupList;
        }

        public void setResGroupList(
                List<QueryResGroupsV41ReturnObjResGroupListResponse> resGroupList) {
            this.resGroupList = resGroupList;
        }

        public Integer getResGroupQuota() {
            return this.resGroupQuota;
        }

        public void setResGroupQuota(Integer resGroupQuota) {
            this.resGroupQuota = resGroupQuota;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class QueryResGroupsV41ReturnObjResGroupListResponse {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 资源分组ID */
        @JsonProperty("resGroupID")
        private String resGroupID;

        /** 名称 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示创建方式。取值范围：<br>
         * instance：实例创建。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("createType")
        private String createType;

        /** 描述 */
        @JsonProperty("desc")
        private String desc;

        /** 最近更新时间，时间戳，秒级 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        /** 创建时间，时间戳，秒级 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 创建方式为实例创建时的资源列表 */
        @JsonProperty("resourceList")
        private List<QueryResGroupsV41ReturnObjResGroupListResourceListResponse> resourceList;

        /** 创建方式为企业项目创建时的企业项目信息 */
        @JsonProperty("projectInfo")
        private QueryResGroupsV41ReturnObjResGroupListProjectInfoResponse projectInfo;

        /**
         * 本参数表示状态。取值范围：<br>
         * 0：未配置告警规则。<br>
         * 1：有告警规则但未告警。<br>
         * 2：告警中。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmStatus")
        private Integer alarmStatus;

        /** 资源分组的告警资源总数 */
        @JsonProperty("totalAlarm")
        private Integer totalAlarm;

        /** 资源分组的规则数 */
        @JsonProperty("totalRule")
        private Integer totalRule;

        /** 资源分组的的资源总数 */
        @JsonProperty("totalResource")
        private Integer totalResource;

        /** 资源分组的资源类型数 */
        @JsonProperty("totalResourceType")
        private Integer totalResourceType;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getResGroupID() {
            return this.resGroupID;
        }

        public void setResGroupID(String resGroupID) {
            this.resGroupID = resGroupID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCreateType() {
            return this.createType;
        }

        public void setCreateType(String createType) {
            this.createType = createType;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public List<QueryResGroupsV41ReturnObjResGroupListResourceListResponse> getResourceList() {
            return this.resourceList;
        }

        public void setResourceList(
                List<QueryResGroupsV41ReturnObjResGroupListResourceListResponse> resourceList) {
            this.resourceList = resourceList;
        }

        public QueryResGroupsV41ReturnObjResGroupListProjectInfoResponse getProjectInfo() {
            return this.projectInfo;
        }

        public void setProjectInfo(
                QueryResGroupsV41ReturnObjResGroupListProjectInfoResponse projectInfo) {
            this.projectInfo = projectInfo;
        }

        public Integer getAlarmStatus() {
            return this.alarmStatus;
        }

        public void setAlarmStatus(Integer alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        public Integer getTotalAlarm() {
            return this.totalAlarm;
        }

        public void setTotalAlarm(Integer totalAlarm) {
            this.totalAlarm = totalAlarm;
        }

        public Integer getTotalRule() {
            return this.totalRule;
        }

        public void setTotalRule(Integer totalRule) {
            this.totalRule = totalRule;
        }

        public Integer getTotalResource() {
            return this.totalResource;
        }

        public void setTotalResource(Integer totalResource) {
            this.totalResource = totalResource;
        }

        public Integer getTotalResourceType() {
            return this.totalResourceType;
        }

        public void setTotalResourceType(Integer totalResourceType) {
            this.totalResourceType = totalResourceType;
        }
    }

    public static class QueryResGroupsV41ReturnObjResGroupListResourceListResponse {
        /** 云监控服务，具体服务参见[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790) */
        @JsonProperty("service")
        private String service;

        /** 云监控维度，具体维度参见[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790) */
        @JsonProperty("dimension")
        private String dimension;

        /** 某一类型下资源总数 */
        @JsonProperty("resourcesTotal")
        private Integer resourcesTotal;

        /** 某一类型下告警中的资源总数 */
        @JsonProperty("alarmNum")
        private Integer alarmNum;

        /** 资源信息列表 */
        @JsonProperty("resources")
        private List<QueryResGroupsV41ReturnObjResGroupListResourceListResourcesResponse> resources;

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public Integer getResourcesTotal() {
            return this.resourcesTotal;
        }

        public void setResourcesTotal(Integer resourcesTotal) {
            this.resourcesTotal = resourcesTotal;
        }

        public Integer getAlarmNum() {
            return this.alarmNum;
        }

        public void setAlarmNum(Integer alarmNum) {
            this.alarmNum = alarmNum;
        }

        public List<QueryResGroupsV41ReturnObjResGroupListResourceListResourcesResponse>
                getResources() {
            return this.resources;
        }

        public void setResources(
                List<QueryResGroupsV41ReturnObjResGroupListResourceListResourcesResponse>
                        resources) {
            this.resources = resources;
        }
    }

    public static class QueryResGroupsV41ReturnObjResGroupListProjectInfoResponse {
        /** 企业项目ID */
        @JsonProperty("projectID")
        private String projectID;

        /** 企业项目产品列表 */
        @JsonProperty("projectProducts")
        private List<QueryResGroupsV41ReturnObjResGroupListProjectInfoProjectProductsResponse>
                projectProducts;

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public List<QueryResGroupsV41ReturnObjResGroupListProjectInfoProjectProductsResponse>
                getProjectProducts() {
            return this.projectProducts;
        }

        public void setProjectProducts(
                List<QueryResGroupsV41ReturnObjResGroupListProjectInfoProjectProductsResponse>
                        projectProducts) {
            this.projectProducts = projectProducts;
        }
    }

    public static class QueryResGroupsV41ReturnObjResGroupListResourceListResourcesResponse {
        /** 资源信息 */
        @JsonProperty("resource")
        private List<QueryResGroupsV41ReturnObjResGroupListResourceListResourcesResourceResponse>
                resource;

        /**
         * 本参数表示具体资源是否告警。取值范围：<br>
         * 0：正常。<br>
         * 1：告警。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        public List<QueryResGroupsV41ReturnObjResGroupListResourceListResourcesResourceResponse>
                getResource() {
            return this.resource;
        }

        public void setResource(
                List<QueryResGroupsV41ReturnObjResGroupListResourceListResourcesResourceResponse>
                        resource) {
            this.resource = resource;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }
    }

    public static class QueryResGroupsV41ReturnObjResGroupListProjectInfoProjectProductsResponse {
        /**
         * 本参数表示服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见“[告警规则：获取告警服务列表](https://www.ctyun.cn/document/10032263/10040008)”接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警维度。取值范围：<br>
         * ecs：云主机。<br>
         * disk：磁盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见“[告警规则：获取告警服务维度关系](https://www.ctyun.cn/document/10032263/10040009)”接口返回。
         */
        @JsonProperty("dimension")
        private String dimension;

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }
    }

    public static
    class QueryResGroupsV41ReturnObjResGroupListResourceListResourcesResourceResponse {
        /** 实例标签名 */
        @JsonProperty("name")
        private String name;

        /** 实例标签对应的值，无效值将无法正常产生告警。 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
