package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询站点监控任务。 */
public class MonitorQuerySiteMonitorApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQuerySiteMonitorApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/monitor/query-site-monitor", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QuerySiteMonitorResponse send(Credential credential, QuerySiteMonitorRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.siteID != null) {
            ctReq.addParam("siteID", request.siteID);
            request.siteID = null;
        }
        if (request.protocol != null) {
            ctReq.addParam("protocol", request.protocol);
            request.protocol = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.search != null) {
            ctReq.addParam("search", request.search);
            request.search = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.page != null) {
            ctReq.addParam("page", String.valueOf(request.page));
            request.page = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QuerySiteMonitorResponse.class);
    }

    public static class QuerySiteMonitorRequest {
        /** 站点监控任务ID */
        @JsonProperty("siteID")
        private String siteID;

        /**
         * 本参数表示探测类型。取值范围：<br>
         * http：http探测。<br>
         * ping：ping探测。<br>
         * tcp：tcp探测。<br>
         * udp：udp探测。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("protocol")
        private String protocol;

        /** 站点监控任务名称，支持中英文 */
        @JsonProperty("name")
        private String name;

        /** 对站点地址（address）进行模糊搜索 */
        @JsonProperty("search")
        private String search;

        /** 页码，默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 页码，默认为1，建议使用pageNo，该参数后续会下线 */
        @JsonProperty("page")
        private Integer page;

        /** 页大小，默认为10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getSiteID() {
            return this.siteID;
        }

        public void setSiteID(String siteID) {
            this.siteID = siteID;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSearch() {
            return this.search;
        }

        public void setSearch(String search) {
            this.search = search;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QuerySiteMonitorResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private QuerySiteMonitorReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QuerySiteMonitorReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QuerySiteMonitorReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QuerySiteMonitorReturnObjResponse {
        /** 站点监控任务列表 */
        @JsonProperty("siteList")
        private List<QuerySiteMonitorReturnObjSiteListResponse> siteList;

        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        /** 当前页记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 页码，建议参考请求参数pageNo，该参数后续会下线 */
        @JsonProperty("page")
        private Integer page;

        /** 页大小，建议参考请求参数pageSize，该参数后续会下线 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public List<QuerySiteMonitorReturnObjSiteListResponse> getSiteList() {
            return this.siteList;
        }

        public void setSiteList(List<QuerySiteMonitorReturnObjSiteListResponse> siteList) {
            this.siteList = siteList;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QuerySiteMonitorReturnObjSiteListResponse {
        /** 站点监控任务ID */
        @JsonProperty("siteID")
        private String siteID;

        /** 站点监控任务ID（底层） */
        @JsonProperty("monitorID")
        private String monitorID;

        /** 站点监控任务名称 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示探测类型。取值范围：<br>
         * http：http探测。<br>
         * ping：ping探测。<br>
         * tcp：tcp探测。<br>
         * udp：udp探测。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("protocol")
        private String protocol;

        /** 站点地址 */
        @JsonProperty("address")
        private String address;

        /** 探测间隔，单位：秒 */
        @JsonProperty("evalInterval")
        private Integer evalInterval;

        /** 探测点 */
        @JsonProperty("probePoint")
        private List<String> probePoint;

        /** 最近更新时间 */
        @JsonProperty("lastChange")
        private String lastChange;

        /** 状态 */
        @JsonProperty("status")
        private Boolean status;

        public String getSiteID() {
            return this.siteID;
        }

        public void setSiteID(String siteID) {
            this.siteID = siteID;
        }

        public String getMonitorID() {
            return this.monitorID;
        }

        public void setMonitorID(String monitorID) {
            this.monitorID = monitorID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public Integer getEvalInterval() {
            return this.evalInterval;
        }

        public void setEvalInterval(Integer evalInterval) {
            this.evalInterval = evalInterval;
        }

        public List<String> getProbePoint() {
            return this.probePoint;
        }

        public void setProbePoint(List<String> probePoint) {
            this.probePoint = probePoint;
        }

        public String getLastChange() {
            return this.lastChange;
        }

        public void setLastChange(String lastChange) {
            this.lastChange = lastChange;
        }

        public Boolean getStatus() {
            return this.status;
        }

        public void setStatus(Boolean status) {
            this.status = status;
        }
    }
}
