package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询系统看板支持的服务维度。 */
public class MonitorQuerySysServicesOfMonitorBoardApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQuerySysServicesOfMonitorBoardApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/monitor-board/query-sys-services",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QuerySysServicesOfMonitorBoardResponse send(
            Credential credential, QuerySysServicesOfMonitorBoardRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QuerySysServicesOfMonitorBoardResponse.class);
    }

    public static class QuerySysServicesOfMonitorBoardRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }
    }

    public static class QuerySysServicesOfMonitorBoardResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QuerySysServicesOfMonitorBoardReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QuerySysServicesOfMonitorBoardReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QuerySysServicesOfMonitorBoardReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QuerySysServicesOfMonitorBoardReturnObjResponse {
        /** 服务维度信息 */
        @JsonProperty("data")
        private List<QuerySysServicesOfMonitorBoardReturnObjDataResponse> data;

        public List<QuerySysServicesOfMonitorBoardReturnObjDataResponse> getData() {
            return this.data;
        }

        public void setData(List<QuerySysServicesOfMonitorBoardReturnObjDataResponse> data) {
            this.data = data;
        }
    }

    public static class QuerySysServicesOfMonitorBoardReturnObjDataResponse {
        /** 云监控服务 */
        @JsonProperty("service")
        private String service;

        /** 云监控服务的名称 */
        @JsonProperty("serviceName")
        private String serviceName;

        /** 云监控维度 */
        @JsonProperty("dimensions")
        private List<QuerySysServicesOfMonitorBoardReturnObjDataDimensionsResponse> dimensions;

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public List<QuerySysServicesOfMonitorBoardReturnObjDataDimensionsResponse> getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(
                List<QuerySysServicesOfMonitorBoardReturnObjDataDimensionsResponse> dimensions) {
            this.dimensions = dimensions;
        }
    }

    public static class QuerySysServicesOfMonitorBoardReturnObjDataDimensionsResponse {
        /** 云监控维度 */
        @JsonProperty("dimension")
        private String dimension;

        /** 云监控维度的名称 */
        @JsonProperty("dimensionName")
        private String dimensionName;

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }
    }
}
