package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可创建巡检结果详情。 */
public class MonitorQueryTaskDetailApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryTaskDetailApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/intelligent-inspection/query-task-detail",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryTaskDetailResponse send(Credential credential, QueryTaskDetailRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryTaskDetailResponse.class);
    }

    public static class QueryTaskDetailRequest {
        /**
         * 本参数表示巡检类型。取值范围：<br>
         * 1：资源健康评估。<br>
         * 2：资源风险识别。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("inspectionType")
        private Integer inspectionType;

        /** 巡检任务ID */
        @JsonProperty("taskID")
        private String taskID;

        /** 页码，默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 页大小，默认为20 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public Integer getInspectionType() {
            return this.inspectionType;
        }

        public void setInspectionType(Integer inspectionType) {
            this.inspectionType = inspectionType;
        }

        public String getTaskID() {
            return this.taskID;
        }

        public void setTaskID(String taskID) {
            this.taskID = taskID;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryTaskDetailResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private QueryTaskDetailReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryTaskDetailReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryTaskDetailReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryTaskDetailReturnObjResponse {
        /** 巡检任务ID */
        @JsonProperty("taskID")
        private String taskID;

        /** 获取对象数据条数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        /** 当前页记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 巡检结果列表 */
        @JsonProperty("inspectionResultList")
        private List<QueryTaskDetailReturnObjInspectionResultListResponse> inspectionResultList;

        public String getTaskID() {
            return this.taskID;
        }

        public void setTaskID(String taskID) {
            this.taskID = taskID;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public List<QueryTaskDetailReturnObjInspectionResultListResponse>
                getInspectionResultList() {
            return this.inspectionResultList;
        }

        public void setInspectionResultList(
                List<QueryTaskDetailReturnObjInspectionResultListResponse> inspectionResultList) {
            this.inspectionResultList = inspectionResultList;
        }
    }

    public static class QueryTaskDetailReturnObjInspectionResultListResponse {
        /**
         * 本参数表示产品类型。取值范围：<br>
         * vm：云主机。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("productType")
        private String productType;

        /**
         * 本参数表示巡检类型。取值范围：<br>
         * 1：资源健康评估。<br>
         * 2：资源风险识别。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("inspectionType")
        private Integer inspectionType;

        /**
         * 本参数表示巡检项。取值范围：<br>
         * 1：云主机性能评估。<br>
         * 2：监控数据健康评估。<br>
         * 3：云主机闲置资源检查。<br>
         * 4：云主机磁盘使用预警评估<br>
         * 根据以上范围取值。
         */
        @JsonProperty("inspectionItem")
        private Integer inspectionItem;

        /**
         * 本参数表示重要等级。取值范围：<br>
         * 1：低。<br>
         * 2：中。<br>
         * 3：高。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("level")
        private Integer level;

        /** 主机名称 */
        @JsonProperty("deviceName")
        private String deviceName;

        public String getProductType() {
            return this.productType;
        }

        public void setProductType(String productType) {
            this.productType = productType;
        }

        public Integer getInspectionType() {
            return this.inspectionType;
        }

        public void setInspectionType(Integer inspectionType) {
            this.inspectionType = inspectionType;
        }

        public Integer getInspectionItem() {
            return this.inspectionItem;
        }

        public void setInspectionItem(Integer inspectionItem) {
            this.inspectionItem = inspectionItem;
        }

        public Integer getLevel() {
            return this.level;
        }

        public void setLevel(Integer level) {
            this.level = level;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }
    }
}
