package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用此接口可创建巡检结果总览。 */
public class MonitorQueryTaskOverviewApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryTaskOverviewApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/intelligent-inspection/query-task-overview",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryTaskOverviewResponse send(Credential credential, QueryTaskOverviewRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryTaskOverviewResponse.class);
    }

    public static class QueryTaskOverviewRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 巡检任务ID */
        @JsonProperty("taskID")
        private String taskID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getTaskID() {
            return this.taskID;
        }

        public void setTaskID(String taskID) {
            this.taskID = taskID;
        }
    }

    public static class QueryTaskOverviewResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private QueryTaskOverviewReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryTaskOverviewReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryTaskOverviewReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryTaskOverviewReturnObjResponse {
        /** 巡检任务ID */
        @JsonProperty("taskID")
        private String taskID;

        /**
         * 本参数表示任务状态码，取值范围：<br>
         * 1：运行中。<br>
         * 2：已完成。<br>
         * 3：失败。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /** 巡检时间，毫秒级。 */
        @JsonProperty("inspectionTime")
        private Integer inspectionTime;

        /** 巡检得分。 */
        @JsonProperty("inspectionScore")
        private Integer inspectionScore;

        /** 健康检查项数量 */
        @JsonProperty("healthCount")
        private Integer healthCount;

        /** 问题数量 */
        @JsonProperty("healthProblemCount")
        private Integer healthProblemCount;

        /** 风险识别项数量 */
        @JsonProperty("riskCount")
        private Integer riskCount;

        /** 风险数量 */
        @JsonProperty("riskProblemCount")
        private Integer riskProblemCount;

        public String getTaskID() {
            return this.taskID;
        }

        public void setTaskID(String taskID) {
            this.taskID = taskID;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getInspectionTime() {
            return this.inspectionTime;
        }

        public void setInspectionTime(Integer inspectionTime) {
            this.inspectionTime = inspectionTime;
        }

        public Integer getInspectionScore() {
            return this.inspectionScore;
        }

        public void setInspectionScore(Integer inspectionScore) {
            this.inspectionScore = inspectionScore;
        }

        public Integer getHealthCount() {
            return this.healthCount;
        }

        public void setHealthCount(Integer healthCount) {
            this.healthCount = healthCount;
        }

        public Integer getHealthProblemCount() {
            return this.healthProblemCount;
        }

        public void setHealthProblemCount(Integer healthProblemCount) {
            this.healthProblemCount = healthProblemCount;
        }

        public Integer getRiskCount() {
            return this.riskCount;
        }

        public void setRiskCount(Integer riskCount) {
            this.riskCount = riskCount;
        }

        public Integer getRiskProblemCount() {
            return this.riskProblemCount;
        }

        public void setRiskProblemCount(Integer riskProblemCount) {
            this.riskProblemCount = riskProblemCount;
        }
    }
}
