package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 重命名监控看板。 */
public class MonitorRenameMonitorBoardApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorRenameMonitorBoardApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/monitor-board/rename",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public RenameMonitorBoardResponse send(Credential credential, RenameMonitorBoardRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(RenameMonitorBoardResponse.class);
    }

    public static class RenameMonitorBoardRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 监控看板ID */
        @JsonProperty("boardID")
        private String boardID;

        /** 新监控面板名称，不可重复 */
        @JsonProperty("name")
        private String name;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getBoardID() {
            return this.boardID;
        }

        public void setBoardID(String boardID) {
            this.boardID = boardID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class RenameMonitorBoardResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private RenameMonitorBoardReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public RenameMonitorBoardReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(RenameMonitorBoardReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class RenameMonitorBoardReturnObjResponse {
        /** 是否成功 */
        @JsonProperty("success")
        private Boolean success;

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }
    }
}
