package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 此接口用于客户配置webhook推送地址时，测试该地址是否可以正常推送消息。当code=800时，代表用户填写的url返回的http状态码为200，但不一定推送成功，需要客户根据响应内容和实际消息接收结果来确认。
 */
public class MonitorTestWebhookApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorTestWebhookApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/monitor/test-webhook", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public TestWebhookResponse send(Credential credential, TestWebhookRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(TestWebhookResponse.class);
    }

    public static class TestWebhookRequest {
        /** webhook推送url */
        @JsonProperty("webhookUrl")
        private String webhookUrl;

        public String getWebhookUrl() {
            return this.webhookUrl;
        }

        public void setWebhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
        }
    }

    public static class TestWebhookResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private TestWebhookReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public TestWebhookReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(TestWebhookReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class TestWebhookReturnObjResponse {
        /** 返回内容 */
        @JsonProperty("data")
        private TestWebhookReturnObjDataResponse data;

        /** 状态码 */
        @JsonProperty("httpStatusCode")
        private Integer httpStatusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 是否成功 */
        @JsonProperty("successResponse")
        private Boolean successResponse;

        public TestWebhookReturnObjDataResponse getData() {
            return this.data;
        }

        public void setData(TestWebhookReturnObjDataResponse data) {
            this.data = data;
        }

        public Integer getHttpStatusCode() {
            return this.httpStatusCode;
        }

        public void setHttpStatusCode(Integer httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Boolean getSuccessResponse() {
            return this.successResponse;
        }

        public void setSuccessResponse(Boolean successResponse) {
            this.successResponse = successResponse;
        }
    }

    public static class TestWebhookReturnObjDataResponse {}
}
