package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 更新指定告警规则， 支持全量字段修改。 */
public class MonitorUpdateAlarmRuleVdaApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorUpdateAlarmRuleVdaApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4.1/monitor/update-alarm-rule",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateAlarmRuleVdaResponse send(Credential credential, UpdateAlarmRuleVdaRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateAlarmRuleVdaResponse.class);
    }

    public static class UpdateAlarmRuleVdaRequest {
        /** 告警规则ID */
        @JsonProperty("alarmRuleID")
        private String alarmRuleID;

        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 规则名 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警维度。取值范围：<br>
         * ecs：云主机。<br>
         * disk：磁盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("dimension")
        private String dimension;

        /** 规则描述 */
        @JsonProperty("desc")
        private String desc;

        /** 重复告警通知次数，默认为0，当repeatTimes值为-1，代表无限重复。 */
        @JsonProperty("repeatTimes")
        private Integer repeatTimes;

        /** 告警接收策略静默时间，多久重复通知一次，单位：秒 */
        @JsonProperty("silenceTime")
        private Integer silenceTime;

        /**
         * 本参数表示恢复是否通知。默认值0。取值范围：<br>
         * 0：否。<br>
         * 1：是。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("recoverNotify")
        private Integer recoverNotify;

        /**
         * 本参数表示告警接收策略。取值范围：<br>
         * email：邮件告警。<br>
         * sms：短信告警。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notifyType")
        private List<String> notifyType;

        /** 告警联系组 */
        @JsonProperty("contactGroupList")
        private List<String> contactGroupList;

        /**
         * 本参数表示通知周期。默认值[0,1,2,3,4,5,6]。取值范围：<br>
         * 0：周日。<br>
         * 1：周一。<br>
         * 2：周二。<br>
         * 3：周三。<br>
         * 4：周四。<br>
         * 5：周五。<br>
         * 6：周六。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notifyWeekdays")
        private List<Integer> notifyWeekdays;

        /** 通知起始时段，默认为00:00:00 */
        @JsonProperty("notifyStart")
        private String notifyStart;

        /** 通知结束时段，默认为23:59:59 */
        @JsonProperty("notifyEnd")
        private String notifyEnd;

        /** webhook消息推送url */
        @JsonProperty("webhookUrl")
        private List<String> webhookUrl;

        /**
         * 资源分组ID，与resources字段互斥。<br>
         * 1.以资源分组为资源对象的告警规则，不需要传入resources。<br>
         * 2.非资源分组为资源对象的告警规则，resources为必填项。
         */
        @JsonProperty("resGroupID")
        private String resGroupID;

        /** 具体告警匹配资源 */
        @JsonProperty("resources")
        private List<UpdateAlarmRuleVdaResourcesRequest> resources;

        /** 项目ID */
        @JsonProperty("projectID")
        private String projectID;

        /**
         * 本参数表示告警策略触发类型。默认值0。取值范围：<br>
         * 0：或，任一条件触发。<br>
         * 1：全部条件满足触发。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("conditionType")
        private Integer conditionType;

        /**
         * 规则的资源范围，默认值0，取值范围：<br>
         * 0：实例资源类型。<br>
         * 1：资源分组类型。<br>
         * 2：全部资源类型 。 <br>
         * 根据以上范围取值。
         */
        @JsonProperty("resourceScope")
        private Integer resourceScope;

        /**
         * 是否使用天翼云默认联系人接收通知，默认值0，取值范围：<br>
         * 0：否。<br>
         * 1：是。 <br>
         * 根据以上范围取值。
         */
        @JsonProperty("defaultContact")
        private Integer defaultContact;

        /** 通知策略ID */
        @JsonProperty("noticeStrategyID")
        private String noticeStrategyID;

        public String getAlarmRuleID() {
            return this.alarmRuleID;
        }

        public void setAlarmRuleID(String alarmRuleID) {
            this.alarmRuleID = alarmRuleID;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public Integer getRepeatTimes() {
            return this.repeatTimes;
        }

        public void setRepeatTimes(Integer repeatTimes) {
            this.repeatTimes = repeatTimes;
        }

        public Integer getSilenceTime() {
            return this.silenceTime;
        }

        public void setSilenceTime(Integer silenceTime) {
            this.silenceTime = silenceTime;
        }

        public Integer getRecoverNotify() {
            return this.recoverNotify;
        }

        public void setRecoverNotify(Integer recoverNotify) {
            this.recoverNotify = recoverNotify;
        }

        public List<String> getNotifyType() {
            return this.notifyType;
        }

        public void setNotifyType(List<String> notifyType) {
            this.notifyType = notifyType;
        }

        public List<String> getContactGroupList() {
            return this.contactGroupList;
        }

        public void setContactGroupList(List<String> contactGroupList) {
            this.contactGroupList = contactGroupList;
        }

        public List<Integer> getNotifyWeekdays() {
            return this.notifyWeekdays;
        }

        public void setNotifyWeekdays(List<Integer> notifyWeekdays) {
            this.notifyWeekdays = notifyWeekdays;
        }

        public String getNotifyStart() {
            return this.notifyStart;
        }

        public void setNotifyStart(String notifyStart) {
            this.notifyStart = notifyStart;
        }

        public String getNotifyEnd() {
            return this.notifyEnd;
        }

        public void setNotifyEnd(String notifyEnd) {
            this.notifyEnd = notifyEnd;
        }

        public List<String> getWebhookUrl() {
            return this.webhookUrl;
        }

        public void setWebhookUrl(List<String> webhookUrl) {
            this.webhookUrl = webhookUrl;
        }

        public String getResGroupID() {
            return this.resGroupID;
        }

        public void setResGroupID(String resGroupID) {
            this.resGroupID = resGroupID;
        }

        public List<UpdateAlarmRuleVdaResourcesRequest> getResources() {
            return this.resources;
        }

        public void setResources(List<UpdateAlarmRuleVdaResourcesRequest> resources) {
            this.resources = resources;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public Integer getConditionType() {
            return this.conditionType;
        }

        public void setConditionType(Integer conditionType) {
            this.conditionType = conditionType;
        }

        public Integer getResourceScope() {
            return this.resourceScope;
        }

        public void setResourceScope(Integer resourceScope) {
            this.resourceScope = resourceScope;
        }

        public Integer getDefaultContact() {
            return this.defaultContact;
        }

        public void setDefaultContact(Integer defaultContact) {
            this.defaultContact = defaultContact;
        }

        public String getNoticeStrategyID() {
            return this.noticeStrategyID;
        }

        public void setNoticeStrategyID(String noticeStrategyID) {
            this.noticeStrategyID = noticeStrategyID;
        }
    }

    public static class UpdateAlarmRuleVdaResourcesRequest {
        /** 资源信息 */
        @JsonProperty("resource")
        private List<UpdateAlarmRuleVdaResourcesResourceRequest> resource;

        public List<UpdateAlarmRuleVdaResourcesResourceRequest> getResource() {
            return this.resource;
        }

        public void setResource(List<UpdateAlarmRuleVdaResourcesResourceRequest> resource) {
            this.resource = resource;
        }
    }

    public static class UpdateAlarmRuleVdaResourcesResourceRequest {
        /** 资源实例标签键 */
        @JsonProperty("name")
        private String name;

        /** 资源实例标签值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class UpdateAlarmRuleVdaResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private UpdateAlarmRuleVdaReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public UpdateAlarmRuleVdaReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateAlarmRuleVdaReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateAlarmRuleVdaReturnObjResponse {
        /** 是否成功 */
        @JsonProperty("success")
        private Boolean success;

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }
    }
}
