package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可更新通知模板。 */
public class MonitorUpdateNoticeTemplateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorUpdateNoticeTemplateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/update-notice-template",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateNoticeTemplateResponse send(
            Credential credential, UpdateNoticeTemplateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateNoticeTemplateResponse.class);
    }

    public static class UpdateNoticeTemplateRequest {
        /** 通知模板ID */
        @JsonProperty("noticeTemplateID")
        private String noticeTemplateID;

        /** 通知模板名称，长度2-40个字符。 */
        @JsonProperty("name")
        private String name;

        /** 通知模板 */
        @JsonProperty("contents")
        private List<UpdateNoticeTemplateContentsRequest> contents;

        public String getNoticeTemplateID() {
            return this.noticeTemplateID;
        }

        public void setNoticeTemplateID(String noticeTemplateID) {
            this.noticeTemplateID = noticeTemplateID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<UpdateNoticeTemplateContentsRequest> getContents() {
            return this.contents;
        }

        public void setContents(List<UpdateNoticeTemplateContentsRequest> contents) {
            this.contents = contents;
        }
    }

    public static class UpdateNoticeTemplateContentsRequest {
        /** 通知模板内容，长度不能超过400个字符。 */
        @JsonProperty("content")
        private String content;

        /**
         * 本参数表示通知方式。取值范围：<br>
         * sms：短信。<br>
         * email：邮件。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notifyType")
        private String notifyType;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getNotifyType() {
            return this.notifyType;
        }

        public void setNotifyType(String notifyType) {
            this.notifyType = notifyType;
        }
    }

    public static class UpdateNoticeTemplateResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private UpdateNoticeTemplateReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public UpdateNoticeTemplateReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateNoticeTemplateReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateNoticeTemplateReturnObjResponse {
        /** 删除成功标识 */
        @JsonProperty("success")
        private Boolean success;

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }
    }
}
