package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 为系统看板增加监控资源实例，会用给定的新资源替换原有旧资源。仅支持系统看板。 */
public class MonitorUpdateSysResourcesOfMonitorBoardApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorUpdateSysResourcesOfMonitorBoardApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/monitor-board/update-sys-resources",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateSysResourcesOfMonitorBoardResponse send(
            Credential credential, UpdateSysResourcesOfMonitorBoardRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateSysResourcesOfMonitorBoardResponse.class);
    }

    public static class UpdateSysResourcesOfMonitorBoardRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 系统监控看板ID */
        @JsonProperty("boardID")
        private String boardID;

        /** 监控资源实例， 监控资源实例最多支持20个 */
        @JsonProperty("resources")
        private List<UpdateSysResourcesOfMonitorBoardResourcesRequest> resources;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getBoardID() {
            return this.boardID;
        }

        public void setBoardID(String boardID) {
            this.boardID = boardID;
        }

        public List<UpdateSysResourcesOfMonitorBoardResourcesRequest> getResources() {
            return this.resources;
        }

        public void setResources(List<UpdateSysResourcesOfMonitorBoardResourcesRequest> resources) {
            this.resources = resources;
        }
    }

    public static class UpdateSysResourcesOfMonitorBoardResourcesRequest {
        /** 资源 */
        @JsonProperty("resource")
        private List<UpdateSysResourcesOfMonitorBoardResourcesResourceRequest> resource;

        public List<UpdateSysResourcesOfMonitorBoardResourcesResourceRequest> getResource() {
            return this.resource;
        }

        public void setResource(
                List<UpdateSysResourcesOfMonitorBoardResourcesResourceRequest> resource) {
            this.resource = resource;
        }
    }

    public static class UpdateSysResourcesOfMonitorBoardResourcesResourceRequest {
        /** 资源键 */
        @JsonProperty("key")
        private String key;

        /** 资源键对应的值 */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class UpdateSysResourcesOfMonitorBoardResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private UpdateSysResourcesOfMonitorBoardReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public UpdateSysResourcesOfMonitorBoardReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateSysResourcesOfMonitorBoardReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateSysResourcesOfMonitorBoardReturnObjResponse {
        /** 是否更新成功 */
        @JsonProperty("success")
        private Boolean success;

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }
    }
}
