package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Map;

/** 调用该接口在指定集群中创建策略治理实例 */
public class CcseCreateClusterPolicyInstanceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseCreateClusterPolicyInstanceApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/cce/clusters/{clusterId}/policies/{policyName}",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateClusterPolicyInstanceResponse send(
            Credential credential, CreateClusterPolicyInstanceRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        if (request.policyName != null) {
            builder.replaceUrl("policyName", request.policyName);
            request.policyName = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateClusterPolicyInstanceResponse.class);
    }

    public static class CreateClusterPolicyInstanceRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 策略治理规则名称，您可以通过查询策略治理规则模版接口来获取： <span style="background-color: rgb(73, 204, 144);color:
         * rgb(255,255,255);padding: 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=43&api=18949&data=128&isNormal=1&vid=121">查询策略治理规则模版</a>
         */
        @JsonProperty("policyName")
        private String policyName;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 模板实例参数，您可以通过查询策略治理规则模版接口来获取： <span style="background-color: rgb(73, 204, 144);color:
         * rgb(255,255,255);padding: 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=43&api=18949&data=128&isNormal=1&vid=121">查询策略治理规则模版</a>
         */
        @JsonProperty("policyParameters")
        private Map<String, Object> policyParameters;

        /** 以逗号分隔的字符串，策略实例实施范围：默认"*"代表集群所有命名空间。 */
        @JsonProperty("policyScope")
        private String policyScope;

        /**
         * 规则治理动作，取值：<br>
         * deny：拦截违规部署<br>
         * warn：告警
         */
        @JsonProperty("policyAction")
        private String policyAction;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Map<String, Object> getPolicyParameters() {
            return this.policyParameters;
        }

        public void setPolicyParameters(Map<String, Object> policyParameters) {
            this.policyParameters = policyParameters;
        }

        public String getPolicyScope() {
            return this.policyScope;
        }

        public void setPolicyScope(String policyScope) {
            this.policyScope = policyScope;
        }

        public String getPolicyAction() {
            return this.policyAction;
        }

        public void setPolicyAction(String policyAction) {
            this.policyAction = policyAction;
        }
    }

    public static class CreateClusterPolicyInstancePolicyParametersRequest {}

    public static class CreateClusterPolicyInstanceResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private CreateClusterPolicyInstanceReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CreateClusterPolicyInstanceReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateClusterPolicyInstanceReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CreateClusterPolicyInstanceReturnObjResponse {
        /** 部署的实例名称列表 */
        @JsonProperty("instances")
        private List<String> instances;

        public List<String> getInstances() {
            return this.instances;
        }

        public void setInstances(List<String> instances) {
            this.instances = instances;
        }
    }
}
