package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用该接口查询集群详情。 */
public class CcseGetClusterApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetClusterApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/cce/clusters/{clusterId}", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetClusterResponse send(Credential credential, GetClusterRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetClusterResponse.class);
    }

    public static class GetClusterRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetClusterResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetClusterReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetClusterReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetClusterReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetClusterReturnObjResponse {
        /** 集群ID */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 集群名称 */
        @JsonProperty("clusterName")
        private String clusterName;

        /** 集群类型，表示如下 0：专有版 2：托管版 */
        @JsonProperty("clusterType")
        private Integer clusterType;

        /** 集群描述 */
        @JsonProperty("clusterDesc")
        private String clusterDesc;

        /** 已废弃；集群部署模式 */
        @JsonProperty("deployMode")
        private String deployMode;

        /** 集群版本 */
        @JsonProperty("clusterVersion")
        private String clusterVersion;

        /**
         * 已废弃；集群状态，取值：<br>
         * normal：正常。<br>
         * creating：创建中。<br>
         * create_fail：创建失败。<br>
         * adjust：规模调整中。<br>
         * updating：升级中。<br>
         * suspend：暂停。<br>
         * deleting：删除中。<br>
         * deleted：已删除。<br>
         * delete_fail：删除失败。<br>
         * resetting：节点重置中。<br>
         * resettled：节点已重置。<br>
         * reset_fail：节点重置失败。<br>
         * upgrading：集群升级中。<br>
         * upgrade_fail：集群升级失败。
         */
        @JsonProperty("clusterStatus")
        private String clusterStatus;

        /**
         * IP协议版本，取值：<br>
         * ipv4：IPv4版本。<br>
         * ipv6：IPv6版本。
         */
        @JsonProperty("ipv4Ipv6")
        private String ipv4Ipv6;

        /**
         * 已废弃；控制面接口协议，取值：<br>
         * ipv4：IPv4版本。<br>
         * ipv6：IPv6版本。
         */
        @JsonProperty("controlPlaneProtocol")
        private String controlPlaneProtocol;

        /** 已废弃；master外网VIP地址 */
        @JsonProperty("masterExtraVip")
        private String masterExtraVip;

        /** 已废弃；master业务VIPv6地址 */
        @JsonProperty("masterExtraVipv6")
        private String masterExtraVipv6;

        /** 已废弃；master内网VIP地址 */
        @JsonProperty("masterIntraVip")
        private String masterIntraVip;

        /** 已废弃；master管理VIPv6地址 */
        @JsonProperty("masterIntraVipv6")
        private String masterIntraVipv6;

        /** ApiServer安全端口 */
        @JsonProperty("securePort")
        private Integer securePort;

        /** 已废弃；ApiServer非安全端口，0表示不开启非安全端口 */
        @JsonProperty("nonSecurePort")
        private Integer nonSecurePort;

        /** 节点服务起始端口 */
        @JsonProperty("startPort")
        private Integer startPort;

        /** 节点服务终止端口 */
        @JsonProperty("endPort")
        private Integer endPort;

        /** Service IP地址范围 */
        @JsonProperty("serviceCidr")
        private String serviceCidr;

        /** Service IPv6地址范围 */
        @JsonProperty("serviceCidrv6")
        private String serviceCidrv6;

        /** Pod IP地址范围 */
        @JsonProperty("podCidr")
        private String podCidr;

        /** Pod IPv6地址范围 */
        @JsonProperty("podCidrv6")
        private String podCidrv6;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 修改时间 */
        @JsonProperty("modifiedTime")
        private String modifiedTime;

        /** master节点数量 */
        @JsonProperty("masterNodeNum")
        private Integer masterNodeNum;

        /** worker节点数量 */
        @JsonProperty("slaveNodeNum")
        private Integer slaveNodeNum;

        /** 已废弃；监控面板grafana地址 */
        @JsonProperty("grafanaAddress")
        private String grafanaAddress;

        /**
         * 业务状态，1：运行中，2：已停止，3：已注销，4：已退订，5：扩容中，6：开通中，7：已取消，9：重启中，10：节点重置中，11：升级中，13：缩容中，14：已过期(冻结、过期)，15：节点升规格中，17：创建失败，18：退订中，19：控制面升配中，20：休眠中，21：唤醒中，22：转订购模式中
         */
        @JsonProperty("bizState")
        private Integer bizState;

        /** 已废弃；渠道标签 */
        @JsonProperty("channelLabel")
        private String channelLabel;

        /** 资源池ID */
        @JsonProperty("resPoolId")
        private String resPoolId;

        /** 资源池名称 */
        @JsonProperty("resPoolName")
        private String resPoolName;

        /** 集群绑定弹性ip */
        @JsonProperty("eip")
        private String eip;

        /** 时区 */
        @JsonProperty("timezone")
        private String timezone;

        /** 容器运行时 */
        @JsonProperty("containerRuntime")
        private String containerRuntime;

        /** 网络插件，包括calico、cubecni */
        @JsonProperty("networkPlugin")
        private String networkPlugin;

        /** kube-proxy 代理模式，包括ipvs、iptables */
        @JsonProperty("kubeProxyPattern")
        private String kubeProxyPattern;

        /** 已废弃；实例ID */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 已废弃；集群规格编码 */
        @JsonProperty("prodId")
        private String prodId;

        /** 到期时间 */
        @JsonProperty("expireTime")
        private String expireTime;

        /** 计费类型 */
        @JsonProperty("billMode")
        private String billMode;

        /** 集群ApiServer Elb IP */
        @JsonProperty("masterSlbIp")
        private String masterSlbIp;

        /** 集群所属VPC ID */
        @JsonProperty("vpcId")
        private String vpcId;

        /** 集群所属VPC名称 */
        @JsonProperty("vpcName")
        private String vpcName;

        /** 集群所属子网 */
        @JsonProperty("subnetUuid")
        private String subnetUuid;

        /** 安全组名称 */
        @JsonProperty("securityGroupName")
        private String securityGroupName;

        /** 安全组ID */
        @JsonProperty("securityGroupId")
        private String securityGroupId;

        /** 集群显示名称 */
        @JsonProperty("clusterAlias")
        private String clusterAlias;

        /** 实例删除保护 */
        @JsonProperty("deleteProtection")
        private Boolean deleteProtection;

        /** 企业项目id */
        @JsonProperty("projectId")
        private String projectId;

        /** 托管集群系列，managedbase：单实例，managedpro：高可用 */
        @JsonProperty("seriesType")
        private String seriesType;

        /** 托管集群的节点规模，50、200、1000、2000 */
        @JsonProperty("nodeScale")
        private String nodeScale;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public Integer getClusterType() {
            return this.clusterType;
        }

        public void setClusterType(Integer clusterType) {
            this.clusterType = clusterType;
        }

        public String getClusterDesc() {
            return this.clusterDesc;
        }

        public void setClusterDesc(String clusterDesc) {
            this.clusterDesc = clusterDesc;
        }

        public String getDeployMode() {
            return this.deployMode;
        }

        public void setDeployMode(String deployMode) {
            this.deployMode = deployMode;
        }

        public String getClusterVersion() {
            return this.clusterVersion;
        }

        public void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public String getClusterStatus() {
            return this.clusterStatus;
        }

        public void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        public String getIpv4Ipv6() {
            return this.ipv4Ipv6;
        }

        public void setIpv4Ipv6(String ipv4Ipv6) {
            this.ipv4Ipv6 = ipv4Ipv6;
        }

        public String getControlPlaneProtocol() {
            return this.controlPlaneProtocol;
        }

        public void setControlPlaneProtocol(String controlPlaneProtocol) {
            this.controlPlaneProtocol = controlPlaneProtocol;
        }

        public String getMasterExtraVip() {
            return this.masterExtraVip;
        }

        public void setMasterExtraVip(String masterExtraVip) {
            this.masterExtraVip = masterExtraVip;
        }

        public String getMasterExtraVipv6() {
            return this.masterExtraVipv6;
        }

        public void setMasterExtraVipv6(String masterExtraVipv6) {
            this.masterExtraVipv6 = masterExtraVipv6;
        }

        public String getMasterIntraVip() {
            return this.masterIntraVip;
        }

        public void setMasterIntraVip(String masterIntraVip) {
            this.masterIntraVip = masterIntraVip;
        }

        public String getMasterIntraVipv6() {
            return this.masterIntraVipv6;
        }

        public void setMasterIntraVipv6(String masterIntraVipv6) {
            this.masterIntraVipv6 = masterIntraVipv6;
        }

        public Integer getSecurePort() {
            return this.securePort;
        }

        public void setSecurePort(Integer securePort) {
            this.securePort = securePort;
        }

        public Integer getNonSecurePort() {
            return this.nonSecurePort;
        }

        public void setNonSecurePort(Integer nonSecurePort) {
            this.nonSecurePort = nonSecurePort;
        }

        public Integer getStartPort() {
            return this.startPort;
        }

        public void setStartPort(Integer startPort) {
            this.startPort = startPort;
        }

        public Integer getEndPort() {
            return this.endPort;
        }

        public void setEndPort(Integer endPort) {
            this.endPort = endPort;
        }

        public String getServiceCidr() {
            return this.serviceCidr;
        }

        public void setServiceCidr(String serviceCidr) {
            this.serviceCidr = serviceCidr;
        }

        public String getServiceCidrv6() {
            return this.serviceCidrv6;
        }

        public void setServiceCidrv6(String serviceCidrv6) {
            this.serviceCidrv6 = serviceCidrv6;
        }

        public String getPodCidr() {
            return this.podCidr;
        }

        public void setPodCidr(String podCidr) {
            this.podCidr = podCidr;
        }

        public String getPodCidrv6() {
            return this.podCidrv6;
        }

        public void setPodCidrv6(String podCidrv6) {
            this.podCidrv6 = podCidrv6;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getModifiedTime() {
            return this.modifiedTime;
        }

        public void setModifiedTime(String modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        public Integer getMasterNodeNum() {
            return this.masterNodeNum;
        }

        public void setMasterNodeNum(Integer masterNodeNum) {
            this.masterNodeNum = masterNodeNum;
        }

        public Integer getSlaveNodeNum() {
            return this.slaveNodeNum;
        }

        public void setSlaveNodeNum(Integer slaveNodeNum) {
            this.slaveNodeNum = slaveNodeNum;
        }

        public String getGrafanaAddress() {
            return this.grafanaAddress;
        }

        public void setGrafanaAddress(String grafanaAddress) {
            this.grafanaAddress = grafanaAddress;
        }

        public Integer getBizState() {
            return this.bizState;
        }

        public void setBizState(Integer bizState) {
            this.bizState = bizState;
        }

        public String getChannelLabel() {
            return this.channelLabel;
        }

        public void setChannelLabel(String channelLabel) {
            this.channelLabel = channelLabel;
        }

        public String getResPoolId() {
            return this.resPoolId;
        }

        public void setResPoolId(String resPoolId) {
            this.resPoolId = resPoolId;
        }

        public String getResPoolName() {
            return this.resPoolName;
        }

        public void setResPoolName(String resPoolName) {
            this.resPoolName = resPoolName;
        }

        public String getEip() {
            return this.eip;
        }

        public void setEip(String eip) {
            this.eip = eip;
        }

        public String getTimezone() {
            return this.timezone;
        }

        public void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public String getContainerRuntime() {
            return this.containerRuntime;
        }

        public void setContainerRuntime(String containerRuntime) {
            this.containerRuntime = containerRuntime;
        }

        public String getNetworkPlugin() {
            return this.networkPlugin;
        }

        public void setNetworkPlugin(String networkPlugin) {
            this.networkPlugin = networkPlugin;
        }

        public String getKubeProxyPattern() {
            return this.kubeProxyPattern;
        }

        public void setKubeProxyPattern(String kubeProxyPattern) {
            this.kubeProxyPattern = kubeProxyPattern;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getProdId() {
            return this.prodId;
        }

        public void setProdId(String prodId) {
            this.prodId = prodId;
        }

        public String getExpireTime() {
            return this.expireTime;
        }

        public void setExpireTime(String expireTime) {
            this.expireTime = expireTime;
        }

        public String getBillMode() {
            return this.billMode;
        }

        public void setBillMode(String billMode) {
            this.billMode = billMode;
        }

        public String getMasterSlbIp() {
            return this.masterSlbIp;
        }

        public void setMasterSlbIp(String masterSlbIp) {
            this.masterSlbIp = masterSlbIp;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public String getVpcName() {
            return this.vpcName;
        }

        public void setVpcName(String vpcName) {
            this.vpcName = vpcName;
        }

        public String getSubnetUuid() {
            return this.subnetUuid;
        }

        public void setSubnetUuid(String subnetUuid) {
            this.subnetUuid = subnetUuid;
        }

        public String getSecurityGroupName() {
            return this.securityGroupName;
        }

        public void setSecurityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
        }

        public String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        public String getClusterAlias() {
            return this.clusterAlias;
        }

        public void setClusterAlias(String clusterAlias) {
            this.clusterAlias = clusterAlias;
        }

        public Boolean getDeleteProtection() {
            return this.deleteProtection;
        }

        public void setDeleteProtection(Boolean deleteProtection) {
            this.deleteProtection = deleteProtection;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getSeriesType() {
            return this.seriesType;
        }

        public void setSeriesType(String seriesType) {
            this.seriesType = seriesType;
        }

        public String getNodeScale() {
            return this.nodeScale;
        }

        public void setNodeScale(String nodeScale) {
            this.nodeScale = nodeScale;
        }
    }
}
