package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口查看集群中策略治理规则下的实例详情 */
public class CcseGetClusterPolicyStatusApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetClusterPolicyStatusApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/policies/status",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetClusterPolicyStatusResponse send(
            Credential credential, GetClusterPolicyStatusRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.policyName != null) {
            ctReq.addParam("policyName", request.policyName);
            request.policyName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetClusterPolicyStatusResponse.class);
    }

    public static class GetClusterPolicyStatusRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 策略名称，您可以通过查询策略治理规则列表接口来获取： <span style="background-color: rgb(73, 204, 144);color:
         * rgb(255,255,255);padding: 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=43&api=18948&data=128&isNormal=1&vid=121">查询策略治理规则列表</a>
         */
        @JsonProperty("policyName")
        private String policyName;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }
    }

    public static class GetClusterPolicyStatusResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetClusterPolicyStatusReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetClusterPolicyStatusReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetClusterPolicyStatusReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetClusterPolicyStatusReturnObjResponse {
        /** 不同策略类型下的策略实例计数列表 */
        @JsonProperty("policyInstances")
        private List<GetClusterPolicyStatusReturnObjPolicyInstancesResponse> policyInstances;

        /** Map<String,Object>类型，集群中当前部署的不同治理等级的策略实例计数 */
        @JsonProperty("instancesSeverityCount")
        private GetClusterPolicyStatusReturnObjInstancesSeverityCountResponse
                instancesSeverityCount;

        public List<GetClusterPolicyStatusReturnObjPolicyInstancesResponse> getPolicyInstances() {
            return this.policyInstances;
        }

        public void setPolicyInstances(
                List<GetClusterPolicyStatusReturnObjPolicyInstancesResponse> policyInstances) {
            this.policyInstances = policyInstances;
        }

        public GetClusterPolicyStatusReturnObjInstancesSeverityCountResponse
                getInstancesSeverityCount() {
            return this.instancesSeverityCount;
        }

        public void setInstancesSeverityCount(
                GetClusterPolicyStatusReturnObjInstancesSeverityCountResponse
                        instancesSeverityCount) {
            this.instancesSeverityCount = instancesSeverityCount;
        }
    }

    public static class GetClusterPolicyStatusReturnObjPolicyInstancesResponse {
        /** 策略类型 */
        @JsonProperty("policyCategory")
        private String policyCategory;

        /** 策略名称 */
        @JsonProperty("policyName")
        private String policyName;

        /** 策略描述 */
        @JsonProperty("policyDescription")
        private String policyDescription;

        /** 策略治理等级 */
        @JsonProperty("policySeverity")
        private String policySeverity;

        /** 已部署的策略实例计数 */
        @JsonProperty("policyInstancesCount")
        private Integer policyInstancesCount;

        public String getPolicyCategory() {
            return this.policyCategory;
        }

        public void setPolicyCategory(String policyCategory) {
            this.policyCategory = policyCategory;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public String getPolicyDescription() {
            return this.policyDescription;
        }

        public void setPolicyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
        }

        public String getPolicySeverity() {
            return this.policySeverity;
        }

        public void setPolicySeverity(String policySeverity) {
            this.policySeverity = policySeverity;
        }

        public Integer getPolicyInstancesCount() {
            return this.policyInstancesCount;
        }

        public void setPolicyInstancesCount(Integer policyInstancesCount) {
            this.policyInstancesCount = policyInstancesCount;
        }
    }

    public static class GetClusterPolicyStatusReturnObjInstancesSeverityCountResponse {
        /** 高级别实例数量 */
        @JsonProperty("high")
        private Integer high;

        /** 中级别实例数量 */
        @JsonProperty("medium")
        private Integer medium;

        /** 低级别实例数量 */
        @JsonProperty("low")
        private Integer low;

        public Integer getHigh() {
            return this.high;
        }

        public void setHigh(Integer high) {
            this.high = high;
        }

        public Integer getMedium() {
            return this.medium;
        }

        public void setMedium(Integer medium) {
            this.medium = medium;
        }

        public Integer getLow() {
            return this.low;
        }

        public void setLow(Integer low) {
            this.low = low;
        }
    }
}
