package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口查询租户集群配额和使用量。 */
public class CcseGetClusterQuotaApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetClusterQuotaApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/cce/quotas/query", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetClusterQuotaResponse send(Credential credential, GetClusterQuotaRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetClusterQuotaResponse.class);
    }

    public static class GetClusterQuotaRequest {
        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetClusterQuotaResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetClusterQuotaReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetClusterQuotaReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetClusterQuotaReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetClusterQuotaReturnObjResponse {
        /** 配额数据列表 */
        @JsonProperty("quotaCenterDataList")
        private List<GetClusterQuotaReturnObjQuotaCenterDataListResponse> quotaCenterDataList;

        public List<GetClusterQuotaReturnObjQuotaCenterDataListResponse> getQuotaCenterDataList() {
            return this.quotaCenterDataList;
        }

        public void setQuotaCenterDataList(
                List<GetClusterQuotaReturnObjQuotaCenterDataListResponse> quotaCenterDataList) {
            this.quotaCenterDataList = quotaCenterDataList;
        }
    }

    public static class GetClusterQuotaReturnObjQuotaCenterDataListResponse {
        /** 用户id */
        @JsonProperty("userId")
        private String userId;

        /** 账户id */
        @JsonProperty("accountId")
        private String accountId;

        /** 租户id */
        @JsonProperty("tenantId")
        private String tenantId;

        /** 资源池id */
        @JsonProperty("regionId")
        private String regionId;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }
}
