package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用该接口查询托管版集群规格变更任务状态。 */
public class CcseGetClusterSeriesTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetClusterSeriesTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/seriestask",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetClusterSeriesTaskResponse send(
            Credential credential, GetClusterSeriesTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.taskId != null) {
            ctReq.addParam("taskId", request.taskId);
            request.taskId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetClusterSeriesTaskResponse.class);
    }

    public static class GetClusterSeriesTaskRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务ID，可通过 变更集群规格 接口获取，不传时默认查询最新的集群规格变更任务状态 */
        @JsonProperty("taskId")
        private String taskId;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }

    public static class GetClusterSeriesTaskResponse {
        /** 请求结果编码 */
        @JsonProperty("code")
        private Integer code;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 集群规格变更任务详情 */
        @JsonProperty("returnObj")
        private GetClusterSeriesTaskReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getCode() {
            return this.code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetClusterSeriesTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetClusterSeriesTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetClusterSeriesTaskReturnObjResponse {
        /** 任务ID */
        @JsonProperty("taskId")
        private String taskId;

        /** 集群ID */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 资源池Id */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务类型，cluster_master_series_modify代表集群规格变更任务 */
        @JsonProperty("taskType")
        private String taskType;

        /** 任务状态 */
        @JsonProperty("taskStatus")
        private String taskStatus;

        /** 并行数 */
        @JsonProperty("parallelNumber")
        private Integer parallelNumber;

        /** 父任务ID */
        @JsonProperty("parentTaskId")
        private Integer parentTaskId;

        /** 任务序列号 */
        @JsonProperty("taskSequenceNumber")
        private Integer taskSequenceNumber;

        /** 子任务数量 */
        @JsonProperty("subtaskSize")
        private Integer subtaskSize;

        /** 已完成的子任务数量 */
        @JsonProperty("completeSubTaskNum")
        private Integer completeSubTaskNum;

        /** 任务内容 */
        @JsonProperty("taskContent")
        private String taskContent;

        /** 任务执行结果 */
        @JsonProperty("taskResult")
        private String taskResult;

        /** 重试次数 */
        @JsonProperty("retryTime")
        private Integer retryTime;

        /** 创建人 */
        @JsonProperty("createdBy")
        private Long createdBy;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 修改时间 */
        @JsonProperty("modifyTime")
        private String modifyTime;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskType() {
            return this.taskType;
        }

        public void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public String getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public Integer getParallelNumber() {
            return this.parallelNumber;
        }

        public void setParallelNumber(Integer parallelNumber) {
            this.parallelNumber = parallelNumber;
        }

        public Integer getParentTaskId() {
            return this.parentTaskId;
        }

        public void setParentTaskId(Integer parentTaskId) {
            this.parentTaskId = parentTaskId;
        }

        public Integer getTaskSequenceNumber() {
            return this.taskSequenceNumber;
        }

        public void setTaskSequenceNumber(Integer taskSequenceNumber) {
            this.taskSequenceNumber = taskSequenceNumber;
        }

        public Integer getSubtaskSize() {
            return this.subtaskSize;
        }

        public void setSubtaskSize(Integer subtaskSize) {
            this.subtaskSize = subtaskSize;
        }

        public Integer getCompleteSubTaskNum() {
            return this.completeSubTaskNum;
        }

        public void setCompleteSubTaskNum(Integer completeSubTaskNum) {
            this.completeSubTaskNum = completeSubTaskNum;
        }

        public String getTaskContent() {
            return this.taskContent;
        }

        public void setTaskContent(String taskContent) {
            this.taskContent = taskContent;
        }

        public String getTaskResult() {
            return this.taskResult;
        }

        public void setTaskResult(String taskResult) {
            this.taskResult = taskResult;
        }

        public Integer getRetryTime() {
            return this.retryTime;
        }

        public void setRetryTime(Integer retryTime) {
            this.retryTime = retryTime;
        }

        public Long getCreatedBy() {
            return this.createdBy;
        }

        public void setCreatedBy(Long createdBy) {
            this.createdBy = createdBy;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getModifyTime() {
            return this.modifyTime;
        }

        public void setModifyTime(String modifyTime) {
            this.modifyTime = modifyTime;
        }
    }
}
