package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询集群服务网段（ServiceCidr资源）列表 */
public class CcseGetClusterServiceCidrApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetClusterServiceCidrApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/apis/networking.k8s.io/v1beta1/servicecidrs",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetClusterServiceCidrResponse send(
            Credential credential, GetClusterServiceCidrRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetClusterServiceCidrResponse.class);
    }

    public static class GetClusterServiceCidrRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetClusterServiceCidrResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 字符串类型的多个ServiceCidr资源yaml定义 */
        @JsonProperty("returnObj")
        private String returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(String returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
