package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询任务详情 */
public class CcseGetClusterTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetClusterTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/cce/tasks/{taskId}", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetClusterTaskResponse send(Credential credential, GetClusterTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.taskId != null) {
            builder.replaceUrl("taskId", request.taskId);
            request.taskId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetClusterTaskResponse.class);
    }

    public static class GetClusterTaskRequest {
        /**
         * 任务ID，具体可参考<a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=43&api=17939&data=128&isNormal=1&vid=121"
         * target="_blank">升级节点池</a>等接口返回值taskId。
         */
        @JsonProperty("taskId")
        private String taskId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetClusterTaskResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求结果 */
        @JsonProperty("returnObj")
        private GetClusterTaskReturnObjResponse returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetClusterTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetClusterTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetClusterTaskReturnObjResponse {
        /** 任务ID */
        @JsonProperty("taskId")
        private String taskId;

        /** 集群ID */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 资源池Id */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务类型 */
        @JsonProperty("taskType")
        private String taskType;

        /** 任务状态 */
        @JsonProperty("taskStatus")
        private String taskStatus;

        /** 并行数 */
        @JsonProperty("parallelNumber")
        private Integer parallelNumber;

        /** 任务内容 */
        @JsonProperty("taskContent")
        private String taskContent;

        /** 任务执行结果 */
        @JsonProperty("taskResult")
        private String taskResult;

        /** 重试次数 */
        @JsonProperty("retryTime")
        private Integer retryTime;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 修改时间 */
        @JsonProperty("modifyTime")
        private String modifyTime;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskType() {
            return this.taskType;
        }

        public void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public String getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public Integer getParallelNumber() {
            return this.parallelNumber;
        }

        public void setParallelNumber(Integer parallelNumber) {
            this.parallelNumber = parallelNumber;
        }

        public String getTaskContent() {
            return this.taskContent;
        }

        public void setTaskContent(String taskContent) {
            this.taskContent = taskContent;
        }

        public String getTaskResult() {
            return this.taskResult;
        }

        public void setTaskResult(String taskResult) {
            this.taskResult = taskResult;
        }

        public Integer getRetryTime() {
            return this.retryTime;
        }

        public void setRetryTime(Integer retryTime) {
            this.retryTime = retryTime;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getModifyTime() {
            return this.modifyTime;
        }

        public void setModifyTime(String modifyTime) {
            this.modifyTime = modifyTime;
        }
    }
}
