package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用该接口查看当前ak对应的用户的集群临时KubeConfig。 */
public class CcseGetClusterTempKubeConfigApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetClusterTempKubeConfigApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/certificate/kubeconfig/temp",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetClusterTempKubeConfigResponse send(
            Credential credential, GetClusterTempKubeConfigRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.addParam("isPublic", String.valueOf(request.isPublic));
        request.isPublic = null;
        if (request.validPeriod != null) {
            ctReq.addParam("validPeriod", String.valueOf(request.validPeriod));
            request.validPeriod = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetClusterTempKubeConfigResponse.class);
    }

    public static class GetClusterTempKubeConfigRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 是否获取公网KubeConfig，公网Kubeconfig需要集群APIServer绑定eip */
        @JsonProperty("isPublic")
        private Boolean isPublic;

        /**
         * KubeConfig有效期，单位为秒；参数取值范围为[600, 2147483647]
         * 注：Kubernetes证书最大有效期由kube-controller-manager参数ClustersigningDuration决定，若设置的validPeriod超过ClustersigningDuration的值，则会被置为ClustersigningDuration的值，ClustersigningDuration参数默认值为一年。生成的KubeConfig实际有效期请通过接口返回的expireDate确认。
         */
        @JsonProperty("validPeriod")
        private Integer validPeriod;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Boolean getIsPublic() {
            return this.isPublic;
        }

        public void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        public Integer getValidPeriod() {
            return this.validPeriod;
        }

        public void setValidPeriod(Integer validPeriod) {
            this.validPeriod = validPeriod;
        }
    }

    public static class GetClusterTempKubeConfigResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetClusterTempKubeConfigReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetClusterTempKubeConfigReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetClusterTempKubeConfigReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetClusterTempKubeConfigReturnObjResponse {
        /** KubeConfig过期时间 */
        @JsonProperty("expireDate")
        private String expireDate;

        /** KubeConfig */
        @JsonProperty("kubeConfig")
        private String kubeConfig;

        public String getExpireDate() {
            return this.expireDate;
        }

        public void setExpireDate(String expireDate) {
            this.expireDate = expireDate;
        }

        public String getKubeConfig() {
            return this.kubeConfig;
        }

        public void setKubeConfig(String kubeConfig) {
            this.kubeConfig = kubeConfig;
        }
    }
}
