package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口查看集群策略治理详情 */
public class CcseGetPolicyGovernanceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetPolicyGovernanceApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/policies/governance",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetPolicyGovernanceResponse send(
            Credential credential, GetPolicyGovernanceRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetPolicyGovernanceResponse.class);
    }

    public static class GetPolicyGovernanceRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetPolicyGovernanceResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetPolicyGovernanceReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetPolicyGovernanceReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetPolicyGovernanceReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetPolicyGovernanceReturnObjResponse {
        /** 当前集群中开启的不同等级策略计数统计 */
        @JsonProperty("onState")
        private List<GetPolicyGovernanceReturnObjOnStateResponse> onState;

        /** 集群中针对不同策略类型的拦截和告警的审计计数统计列表 */
        @JsonProperty("violations")
        private GetPolicyGovernanceReturnObjViolationsResponse violations;

        /** 集群当前策略治理审计日志 */
        @JsonProperty("admitLog")
        private GetPolicyGovernanceReturnObjAdmitLogResponse admitLog;

        public List<GetPolicyGovernanceReturnObjOnStateResponse> getOnState() {
            return this.onState;
        }

        public void setOnState(List<GetPolicyGovernanceReturnObjOnStateResponse> onState) {
            this.onState = onState;
        }

        public GetPolicyGovernanceReturnObjViolationsResponse getViolations() {
            return this.violations;
        }

        public void setViolations(GetPolicyGovernanceReturnObjViolationsResponse violations) {
            this.violations = violations;
        }

        public GetPolicyGovernanceReturnObjAdmitLogResponse getAdmitLog() {
            return this.admitLog;
        }

        public void setAdmitLog(GetPolicyGovernanceReturnObjAdmitLogResponse admitLog) {
            this.admitLog = admitLog;
        }
    }

    public static class GetPolicyGovernanceReturnObjOnStateResponse {
        /** 策略治理等级 */
        @JsonProperty("severity")
        private String severity;

        /** 该等级下策略种类总数 */
        @JsonProperty("total")
        private Long total;

        /** 当前开启的策略种类计数 */
        @JsonProperty("enabledCount")
        private Long enabledCount;

        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String severity) {
            this.severity = severity;
        }

        public Long getTotal() {
            return this.total;
        }

        public void setTotal(Long total) {
            this.total = total;
        }

        public Long getEnabledCount() {
            return this.enabledCount;
        }

        public void setEnabledCount(Long enabledCount) {
            this.enabledCount = enabledCount;
        }
    }

    public static class GetPolicyGovernanceReturnObjViolationsResponse {
        /** 拦截模式下不同治理等级的违规计数统计 */
        @JsonProperty("deny")
        private List<GetPolicyGovernanceReturnObjViolationsDenyResponse> deny;

        /** 告警模式下不同治理等级的违规计数统计 */
        @JsonProperty("warn")
        private List<GetPolicyGovernanceReturnObjViolationsWarnResponse> warn;

        /** 告警模式下High治理等级的违规计数统计 */
        @JsonProperty("denyCount")
        private GetPolicyGovernanceReturnObjViolationsDenyCountResponse denyCount;

        /** 告警模式下Medium治理等级的违规计数统计 */
        @JsonProperty("warnCount")
        private GetPolicyGovernanceReturnObjViolationsWarnCountResponse warnCount;

        public List<GetPolicyGovernanceReturnObjViolationsDenyResponse> getDeny() {
            return this.deny;
        }

        public void setDeny(List<GetPolicyGovernanceReturnObjViolationsDenyResponse> deny) {
            this.deny = deny;
        }

        public List<GetPolicyGovernanceReturnObjViolationsWarnResponse> getWarn() {
            return this.warn;
        }

        public void setWarn(List<GetPolicyGovernanceReturnObjViolationsWarnResponse> warn) {
            this.warn = warn;
        }

        public GetPolicyGovernanceReturnObjViolationsDenyCountResponse getDenyCount() {
            return this.denyCount;
        }

        public void setDenyCount(
                GetPolicyGovernanceReturnObjViolationsDenyCountResponse denyCount) {
            this.denyCount = denyCount;
        }

        public GetPolicyGovernanceReturnObjViolationsWarnCountResponse getWarnCount() {
            return this.warnCount;
        }

        public void setWarnCount(
                GetPolicyGovernanceReturnObjViolationsWarnCountResponse warnCount) {
            this.warnCount = warnCount;
        }
    }

    public static class GetPolicyGovernanceReturnObjAdmitLogResponse {
        /** 查询结果的状态:Complete, Incomplete */
        @JsonProperty("progress")
        private String progress;

        /** 当前查询到的日志总数 */
        @JsonProperty("count")
        private Long count;

        /** 策略治理审计日志内容 */
        @JsonProperty("log")
        private List<GetPolicyGovernanceReturnObjAdmitLogLogResponse> log;

        public String getProgress() {
            return this.progress;
        }

        public void setProgress(String progress) {
            this.progress = progress;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public List<GetPolicyGovernanceReturnObjAdmitLogLogResponse> getLog() {
            return this.log;
        }

        public void setLog(List<GetPolicyGovernanceReturnObjAdmitLogLogResponse> log) {
            this.log = log;
        }
    }

    public static class GetPolicyGovernanceReturnObjViolationsDenyResponse {
        /** 策略名称 */
        @JsonProperty("policyName")
        private String policyName;

        /** 策略描述 */
        @JsonProperty("policyDesc")
        private String policyDesc;

        /** 集群中对应规则类型下被拦截的违规计数统计 */
        @JsonProperty("violations")
        private Integer violations;

        /** 策略治理等级 */
        @JsonProperty("severity")
        private String severity;

        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public String getPolicyDesc() {
            return this.policyDesc;
        }

        public void setPolicyDesc(String policyDesc) {
            this.policyDesc = policyDesc;
        }

        public Integer getViolations() {
            return this.violations;
        }

        public void setViolations(Integer violations) {
            this.violations = violations;
        }

        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String severity) {
            this.severity = severity;
        }
    }

    public static class GetPolicyGovernanceReturnObjViolationsWarnResponse {
        /** 策略名称 */
        @JsonProperty("policyName")
        private String policyName;

        /** 策略描述 */
        @JsonProperty("policyDesc")
        private String policyDesc;

        /** 集群中对应规则类型下被拦截的违规计数统计 */
        @JsonProperty("violations")
        private Integer violations;

        /** 策略治理等级 */
        @JsonProperty("severity")
        private String severity;

        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public String getPolicyDesc() {
            return this.policyDesc;
        }

        public void setPolicyDesc(String policyDesc) {
            this.policyDesc = policyDesc;
        }

        public Integer getViolations() {
            return this.violations;
        }

        public void setViolations(Integer violations) {
            this.violations = violations;
        }

        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String severity) {
            this.severity = severity;
        }
    }

    public static class GetPolicyGovernanceReturnObjViolationsDenyCountResponse {
        /** 高级别违规计数统计 */
        @JsonProperty("high")
        private Integer high;

        /** 中级别违规计数统计 */
        @JsonProperty("medium")
        private Integer medium;

        /** 低级别违规计数统计 */
        @JsonProperty("low")
        private Integer low;

        public Integer getHigh() {
            return this.high;
        }

        public void setHigh(Integer high) {
            this.high = high;
        }

        public Integer getMedium() {
            return this.medium;
        }

        public void setMedium(Integer medium) {
            this.medium = medium;
        }

        public Integer getLow() {
            return this.low;
        }

        public void setLow(Integer low) {
            this.low = low;
        }
    }

    public static class GetPolicyGovernanceReturnObjViolationsWarnCountResponse {
        /** 高级别违规计数统计 */
        @JsonProperty("high")
        private Integer high;

        /** 中级别违规计数统计 */
        @JsonProperty("medium")
        private Integer medium;

        /** 低级别违规计数统计 */
        @JsonProperty("low")
        private Integer low;

        public Integer getHigh() {
            return this.high;
        }

        public void setHigh(Integer high) {
            this.high = high;
        }

        public Integer getMedium() {
            return this.medium;
        }

        public void setMedium(Integer medium) {
            this.medium = medium;
        }

        public Integer getLow() {
            return this.low;
        }

        public void setLow(Integer low) {
            this.low = low;
        }
    }

    public static class GetPolicyGovernanceReturnObjAdmitLogLogResponse {
        /** 目标集群ID */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 策略类型名称 */
        @JsonProperty("constraintKind")
        private Long constraintKind;

        /** 目标资源名称 */
        @JsonProperty("resourceName")
        private String resourceName;

        /** 目标资源类型 */
        @JsonProperty("resourceKind")
        private String resourceKind;

        /** 目标资源命名空间 */
        @JsonProperty("resourceNamespace")
        private String resourceNamespace;

        /** 策略治理审计日志信息 */
        @JsonProperty("msg")
        private String msg;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public Long getConstraintKind() {
            return this.constraintKind;
        }

        public void setConstraintKind(Long constraintKind) {
            this.constraintKind = constraintKind;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public String getResourceKind() {
            return this.resourceKind;
        }

        public void setResourceKind(String resourceKind) {
            this.resourceKind = resourceKind;
        }

        public String getResourceNamespace() {
            return this.resourceNamespace;
        }

        public void setResourceNamespace(String resourceNamespace) {
            this.resourceNamespace = resourceNamespace;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}
