package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用该接口查看策略治理规则模板详情 */
public class CcseGetPolicyTemplateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetPolicyTemplateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/cce/policies/{policyName}", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetPolicyTemplateResponse send(Credential credential, GetPolicyTemplateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.policyName != null) {
            builder.replaceUrl("policyName", request.policyName);
            request.policyName = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetPolicyTemplateResponse.class);
    }

    public static class GetPolicyTemplateRequest {
        /**
         * 策略治理规则名称，您可以通过查询策略治理规则列表接口来获取： <span style="background-color: rgb(73, 204, 144);color:
         * rgb(255,255,255);padding: 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=43&api=18948&data=128&isNormal=1&vid=121">查询策略治理规则列表</a>
         */
        @JsonProperty("policyName")
        private String policyName;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetPolicyTemplateResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetPolicyTemplateReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetPolicyTemplateReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetPolicyTemplateReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetPolicyTemplateReturnObjResponse {
        /** 规则ID */
        @JsonProperty("policyId")
        private Long policyId;

        /** 规则名称 */
        @JsonProperty("name")
        private String name;

        /** 规则模板类型 */
        @JsonProperty("category")
        private String category;

        /** 规则模板描述 */
        @JsonProperty("desc")
        private String desc;

        /**
         * 规则治理动作，取值：<br>
         * enforce：拦截违规部署<br>
         * inform：告警
         */
        @JsonProperty("action")
        private String action;

        /**
         * 规则治理等级，取值：<br>
         * high<br>
         * medium<br>
         * low
         */
        @JsonProperty("severity")
        private String severity;

        /**
         * 是否需要配置策略，取值：<br>
         * 0：需要<br>
         * 1：不需要
         */
        @JsonProperty("noConfig")
        private Integer noConfig;

        /** 规则模板详情 */
        @JsonProperty("template")
        private String template;

        /** 实例规则模板详情 */
        @JsonProperty("instanceTemplate")
        private String instanceTemplate;

        /**
         * 状态，取值：<br>
         * 1：有效<br>
         * 2：删除
         */
        @JsonProperty("status")
        private Integer status;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 创建人 */
        @JsonProperty("createdBy")
        private Long createdBy;

        /** 修改时间 */
        @JsonProperty("modifiedTime")
        private String modifiedTime;

        /** 修改人 */
        @JsonProperty("modifiedBy")
        private Long modifiedBy;

        public Long getPolicyId() {
            return this.policyId;
        }

        public void setPolicyId(Long policyId) {
            this.policyId = policyId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getSeverity() {
            return this.severity;
        }

        public void setSeverity(String severity) {
            this.severity = severity;
        }

        public Integer getNoConfig() {
            return this.noConfig;
        }

        public void setNoConfig(Integer noConfig) {
            this.noConfig = noConfig;
        }

        public String getTemplate() {
            return this.template;
        }

        public void setTemplate(String template) {
            this.template = template;
        }

        public String getInstanceTemplate() {
            return this.instanceTemplate;
        }

        public void setInstanceTemplate(String instanceTemplate) {
            this.instanceTemplate = instanceTemplate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public Long getCreatedBy() {
            return this.createdBy;
        }

        public void setCreatedBy(Long createdBy) {
            this.createdBy = createdBy;
        }

        public String getModifiedTime() {
            return this.modifiedTime;
        }

        public void setModifiedTime(String modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        public Long getModifiedBy() {
            return this.modifiedBy;
        }

        public void setModifiedBy(Long modifiedBy) {
            this.modifiedBy = modifiedBy;
        }
    }
}
