package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取公共镜像及其信息列表 */
public class CcseGetPublicImageListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetPublicImageListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/cce/osimages", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetPublicImageListResponse send(Credential credential, GetPublicImageListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.flavorName != null) {
            ctReq.addParam("flavorName", request.flavorName);
            request.flavorName = null;
        }
        if (request.vmType != null) {
            ctReq.addParam("vmType", request.vmType);
            request.vmType = null;
        }
        if (request.projectId != null) {
            ctReq.addParam("projectId", request.projectId);
            request.projectId = null;
        }
        if (request.azName != null) {
            ctReq.addParam("azName", request.azName);
            request.azName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetPublicImageListResponse.class);
    }

    public static class GetPublicImageListRequest {
        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10026730/10028695">地域和可用区</a>来了解资源池 获取：
         * <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px;
         * margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&amp;api=5851&amp;data=87">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 云主机规格名称 */
        @JsonProperty("flavorName")
        private String flavorName;

        /** 查询镜像类型，默认ecs。 ecs - 云主机镜像 ebm - 裸金属镜像 */
        @JsonProperty("vmType")
        private String vmType;

        /** 企业项目ID */
        @JsonProperty("projectId")
        private String projectId;

        /** 平台可用区名称，查询裸金属镜像时必填 */
        @JsonProperty("azName")
        private String azName;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getFlavorName() {
            return this.flavorName;
        }

        public void setFlavorName(String flavorName) {
            this.flavorName = flavorName;
        }

        public String getVmType() {
            return this.vmType;
        }

        public void setVmType(String vmType) {
            this.vmType = vmType;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }
    }

    public static class GetPublicImageListResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回数据列表 */
        @JsonProperty("returnObj")
        private List<GetPublicImageListReturnObjResponse> returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<GetPublicImageListReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<GetPublicImageListReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetPublicImageListReturnObjResponse {
        /** 镜像类别 ECS - 云主机 BMS - 裸金属物理机 */
        @JsonProperty("imageClass")
        private String imageClass;

        /** 镜像ID */
        @JsonProperty("imageID")
        private String imageID;

        /** 镜像名称 */
        @JsonProperty("imageName")
        private String imageName;

        /** 操作系统类型 linux - Linux操作系统 windows - Windows操作系统 */
        @JsonProperty("osType")
        private String osType;

        /** 操作系统发行版 */
        @JsonProperty("osDistro")
        private String osDistro;

        /** 操作系统版本 */
        @JsonProperty("osVersion")
        private String osVersion;

        /** 镜像是否公共可见 */
        @JsonProperty("visibility")
        private String visibility;

        /**
         * 系统架构 aarch64 - AArch64 架构 loongarch64 - LoongArch64 架构 sw_64 - sw_64 架构 x86_64 - x86_64
         * 架构
         */
        @JsonProperty("architecture")
        private String architecture;

        public String getImageClass() {
            return this.imageClass;
        }

        public void setImageClass(String imageClass) {
            this.imageClass = imageClass;
        }

        public String getImageID() {
            return this.imageID;
        }

        public void setImageID(String imageID) {
            this.imageID = imageID;
        }

        public String getImageName() {
            return this.imageName;
        }

        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public String getOsType() {
            return this.osType;
        }

        public void setOsType(String osType) {
            this.osType = osType;
        }

        public String getOsDistro() {
            return this.osDistro;
        }

        public void setOsDistro(String osDistro) {
            this.osDistro = osDistro;
        }

        public String getOsVersion() {
            return this.osVersion;
        }

        public void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        public String getVisibility() {
            return this.visibility;
        }

        public void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public void setArchitecture(String architecture) {
            this.architecture = architecture;
        }
    }
}
