package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口查看集群升级状态。 */
public class CcseGetUpgradeClusterStatusApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetUpgradeClusterStatusApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/upgrade/status",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetUpgradeClusterStatusResponse send(
            Credential credential, GetUpgradeClusterStatusRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.taskId != null) {
            ctReq.addParam("taskId", String.valueOf(request.taskId));
            request.taskId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetUpgradeClusterStatusResponse.class);
    }

    public static class GetUpgradeClusterStatusRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 任务ID，您可以在升级集群接口获取任务ID 获取： <span style="background-color: rgb(73, 204, 144);color:
         * rgb(255,255,255);padding: 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=43&api=18045&data=128&isNormal=1&vid=121">升级集群</a>
         */
        @JsonProperty("taskId")
        private Long taskId;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Long getTaskId() {
            return this.taskId;
        }

        public void setTaskId(Long taskId) {
            this.taskId = taskId;
        }
    }

    public static class GetUpgradeClusterStatusResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<GetUpgradeClusterStatusReturnObjResponse> returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<GetUpgradeClusterStatusReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<GetUpgradeClusterStatusReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetUpgradeClusterStatusReturnObjResponse {
        /** master0任务id */
        @JsonProperty("taskId")
        private Long taskId;

        /** 集群升级任务 */
        @JsonProperty("tasks")
        private List<GetUpgradeClusterStatusReturnObjTasksResponse> tasks;

        public Long getTaskId() {
            return this.taskId;
        }

        public void setTaskId(Long taskId) {
            this.taskId = taskId;
        }

        public List<GetUpgradeClusterStatusReturnObjTasksResponse> getTasks() {
            return this.tasks;
        }

        public void setTasks(List<GetUpgradeClusterStatusReturnObjTasksResponse> tasks) {
            this.tasks = tasks;
        }
    }

    public static class GetUpgradeClusterStatusReturnObjTasksResponse {
        /** 任务ID */
        @JsonProperty("taskId")
        private Long taskId;

        /** 集群ID */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 上级任务ID */
        @JsonProperty("parentTaskId")
        private Long parentTaskId;

        /** 升级节点名称 */
        @JsonProperty("nodeName")
        private String nodeName;

        /** 升级节点类型：master0, master, node */
        @JsonProperty("nodeType")
        private String nodeType;

        /** 升级master使用crd的latest hash */
        @JsonProperty("masterPlanHash")
        private String masterPlanHash;

        /** 升级worker使用crd的latest hash */
        @JsonProperty("workerPlanHash")
        private String workerPlanHash;

        /** 升级状态：start-开始升级，end-完成升级，pause-暂停升级 */
        @JsonProperty("taskStatus")
        private String taskStatus;

        /** 升级版本 */
        @JsonProperty("version")
        private String version;

        /** 状态 0-无效 1-有效 2-删除 */
        @JsonProperty("status")
        private Integer status;

        /** 创建人 */
        @JsonProperty("createdBy")
        private Long createdBy;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 修改时间 */
        @JsonProperty("updatedTime")
        private String updatedTime;

        public Long getTaskId() {
            return this.taskId;
        }

        public void setTaskId(Long taskId) {
            this.taskId = taskId;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public Long getParentTaskId() {
            return this.parentTaskId;
        }

        public void setParentTaskId(Long parentTaskId) {
            this.parentTaskId = parentTaskId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public String getMasterPlanHash() {
            return this.masterPlanHash;
        }

        public void setMasterPlanHash(String masterPlanHash) {
            this.masterPlanHash = masterPlanHash;
        }

        public String getWorkerPlanHash() {
            return this.workerPlanHash;
        }

        public void setWorkerPlanHash(String workerPlanHash) {
            this.workerPlanHash = workerPlanHash;
        }

        public String getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCreatedBy() {
            return this.createdBy;
        }

        public void setCreatedBy(Long createdBy) {
            this.createdBy = createdBy;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getUpdatedTime() {
            return this.updatedTime;
        }

        public void setUpdatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
        }
    }
}
