package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口根据集群id，查询该集群中的所有节点的详情。 */
public class CcseListClusterNodesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseListClusterNodesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/nodes/list",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListClusterNodesResponse send(Credential credential, ListClusterNodesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.nodeName != null) {
            ctReq.addParam("nodeName", request.nodeName);
            request.nodeName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListClusterNodesResponse.class);
    }

    public static class ListClusterNodesRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 集群节点名称 */
        @JsonProperty("nodeName")
        private String nodeName;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }
    }

    public static class ListClusterNodesResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<ListClusterNodesReturnObjResponse> returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<ListClusterNodesReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ListClusterNodesReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ListClusterNodesReturnObjResponse {
        /** 集群节点名称 */
        @JsonProperty("nodeName")
        private String nodeName;

        /**
         * 节点类型，取值：<br>
         * 1：master <br>
         * 2：slave
         */
        @JsonProperty("nodeType")
        private Integer nodeType;

        /**
         * 节点状态，取值：<br>
         * normal：健康<br>
         * abnormal：异常<br>
         * expulsion：驱逐中
         */
        @JsonProperty("nodeStatus")
        private String nodeStatus;

        /**
         * 是否调度，取值： 1：是 <br>
         * 0：否
         */
        @JsonProperty("isSchedule")
        private Integer isSchedule;

        /**
         * 是否驱逐，取值： 1：是 <br>
         * 0：否
         */
        @JsonProperty("isEvict")
        private Integer isEvict;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 主机管理ip */
        @JsonProperty("hostIp")
        private String hostIp;

        /** 主机管理ipv6 */
        @JsonProperty("hostIpv6")
        private String hostIpv6;

        /** 主机业务ip */
        @JsonProperty("hostExtraIp")
        private String hostExtraIp;

        /** 主机业务ipv6 */
        @JsonProperty("hostExtraIpv6")
        private String hostExtraIpv6;

        /** Kubelet 版本 */
        @JsonProperty("kubeletVersion")
        private String kubeletVersion;

        /** Pod CIDR */
        @JsonProperty("podCidr")
        private String podCidr;

        /** 内核版本 */
        @JsonProperty("kernelVersion")
        private String kernelVersion;

        /** OS 镜像 */
        @JsonProperty("osImageVersion")
        private String osImageVersion;

        /** KubeProxy 版本 */
        @JsonProperty("kubeProxyVersion")
        private String kubeProxyVersion;

        /** 容器版本 */
        @JsonProperty("dockerVersion")
        private String dockerVersion;

        /** 渠道标签 */
        @JsonProperty("channelLabel")
        private String channelLabel;

        /** docker数据目录 */
        @JsonProperty("dockerDataPath")
        private String dockerDataPath;

        /** 云主机ID */
        @JsonProperty("ecsId")
        private String ecsId;

        /** host类型 */
        @JsonProperty("hostType")
        private String hostType;

        /** 登陆类型 */
        @JsonProperty("loginType")
        private String loginType;

        /** 节点系统盘类型 */
        @JsonProperty("sysDiskType")
        private String sysDiskType;

        /** 节点系统盘大小 */
        @JsonProperty("sysDiskSize")
        private Integer sysDiskSize;

        /** 自定义容器数据目录 */
        @JsonProperty("containerDataDirectory")
        private String containerDataDirectory;

        /** 部署后执行自定义脚本 */
        @JsonProperty("visibilityPostHostScript")
        private String visibilityPostHostScript;

        /** kubelet参数 */
        @JsonProperty("kubeletArgs")
        private ListClusterNodesReturnObjKubeletArgsResponse kubeletArgs;

        /** 可用区名称 */
        @JsonProperty("zoneName")
        private String zoneName;

        /** 可用区编码 */
        @JsonProperty("zoneCode")
        private String zoneCode;

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public Integer getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(Integer nodeType) {
            this.nodeType = nodeType;
        }

        public String getNodeStatus() {
            return this.nodeStatus;
        }

        public void setNodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
        }

        public Integer getIsSchedule() {
            return this.isSchedule;
        }

        public void setIsSchedule(Integer isSchedule) {
            this.isSchedule = isSchedule;
        }

        public Integer getIsEvict() {
            return this.isEvict;
        }

        public void setIsEvict(Integer isEvict) {
            this.isEvict = isEvict;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getHostIp() {
            return this.hostIp;
        }

        public void setHostIp(String hostIp) {
            this.hostIp = hostIp;
        }

        public String getHostIpv6() {
            return this.hostIpv6;
        }

        public void setHostIpv6(String hostIpv6) {
            this.hostIpv6 = hostIpv6;
        }

        public String getHostExtraIp() {
            return this.hostExtraIp;
        }

        public void setHostExtraIp(String hostExtraIp) {
            this.hostExtraIp = hostExtraIp;
        }

        public String getHostExtraIpv6() {
            return this.hostExtraIpv6;
        }

        public void setHostExtraIpv6(String hostExtraIpv6) {
            this.hostExtraIpv6 = hostExtraIpv6;
        }

        public String getKubeletVersion() {
            return this.kubeletVersion;
        }

        public void setKubeletVersion(String kubeletVersion) {
            this.kubeletVersion = kubeletVersion;
        }

        public String getPodCidr() {
            return this.podCidr;
        }

        public void setPodCidr(String podCidr) {
            this.podCidr = podCidr;
        }

        public String getKernelVersion() {
            return this.kernelVersion;
        }

        public void setKernelVersion(String kernelVersion) {
            this.kernelVersion = kernelVersion;
        }

        public String getOsImageVersion() {
            return this.osImageVersion;
        }

        public void setOsImageVersion(String osImageVersion) {
            this.osImageVersion = osImageVersion;
        }

        public String getKubeProxyVersion() {
            return this.kubeProxyVersion;
        }

        public void setKubeProxyVersion(String kubeProxyVersion) {
            this.kubeProxyVersion = kubeProxyVersion;
        }

        public String getDockerVersion() {
            return this.dockerVersion;
        }

        public void setDockerVersion(String dockerVersion) {
            this.dockerVersion = dockerVersion;
        }

        public String getChannelLabel() {
            return this.channelLabel;
        }

        public void setChannelLabel(String channelLabel) {
            this.channelLabel = channelLabel;
        }

        public String getDockerDataPath() {
            return this.dockerDataPath;
        }

        public void setDockerDataPath(String dockerDataPath) {
            this.dockerDataPath = dockerDataPath;
        }

        public String getEcsId() {
            return this.ecsId;
        }

        public void setEcsId(String ecsId) {
            this.ecsId = ecsId;
        }

        public String getHostType() {
            return this.hostType;
        }

        public void setHostType(String hostType) {
            this.hostType = hostType;
        }

        public String getLoginType() {
            return this.loginType;
        }

        public void setLoginType(String loginType) {
            this.loginType = loginType;
        }

        public String getSysDiskType() {
            return this.sysDiskType;
        }

        public void setSysDiskType(String sysDiskType) {
            this.sysDiskType = sysDiskType;
        }

        public Integer getSysDiskSize() {
            return this.sysDiskSize;
        }

        public void setSysDiskSize(Integer sysDiskSize) {
            this.sysDiskSize = sysDiskSize;
        }

        public String getContainerDataDirectory() {
            return this.containerDataDirectory;
        }

        public void setContainerDataDirectory(String containerDataDirectory) {
            this.containerDataDirectory = containerDataDirectory;
        }

        public String getVisibilityPostHostScript() {
            return this.visibilityPostHostScript;
        }

        public void setVisibilityPostHostScript(String visibilityPostHostScript) {
            this.visibilityPostHostScript = visibilityPostHostScript;
        }

        public ListClusterNodesReturnObjKubeletArgsResponse getKubeletArgs() {
            return this.kubeletArgs;
        }

        public void setKubeletArgs(ListClusterNodesReturnObjKubeletArgsResponse kubeletArgs) {
            this.kubeletArgs = kubeletArgs;
        }

        public String getZoneName() {
            return this.zoneName;
        }

        public void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public String getZoneCode() {
            return this.zoneCode;
        }

        public void setZoneCode(String zoneCode) {
            this.zoneCode = zoneCode;
        }
    }

    public static class ListClusterNodesReturnObjKubeletArgsResponse {}
}
