package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口查看集群中当前部署的策略实例 */
public class CcseListClusterPolicyInstancesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseListClusterPolicyInstancesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/policies/instances",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListClusterPolicyInstancesResponse send(
            Credential credential, ListClusterPolicyInstancesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.policyName != null) {
            ctReq.addParam("policyName", request.policyName);
            request.policyName = null;
        }
        if (request.instanceName != null) {
            ctReq.addParam("instanceName", request.instanceName);
            request.instanceName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListClusterPolicyInstancesResponse.class);
    }

    public static class ListClusterPolicyInstancesRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 策略治理规则名称，您可以通过查询策略治理规则列表接口来获取： <span style="background-color: rgb(73, 204, 144);color:
         * rgb(255,255,255);padding: 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=43&api=18948&data=128&isNormal=1&vid=121">查询策略治理规则列表</a>
         */
        @JsonProperty("policyName")
        private String policyName;

        /** 策略规则实例名称 */
        @JsonProperty("instanceName")
        private String instanceName;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }
    }

    public static class ListClusterPolicyInstancesResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<ListClusterPolicyInstancesReturnObjResponse> returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<ListClusterPolicyInstancesReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ListClusterPolicyInstancesReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ListClusterPolicyInstancesReturnObjResponse {
        /** 规则ID */
        @JsonProperty("instanceId")
        private Long instanceId;

        /** 实例名称 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 集群标识ID */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 策略规则名称 */
        @JsonProperty("policyName")
        private String policyName;

        /** 策略模板类型 */
        @JsonProperty("policyCategory")
        private String policyCategory;

        /** 策略模板描述 */
        @JsonProperty("policyDesc")
        private String policyDesc;

        /** 当前规则实例的配置参数 */
        @JsonProperty("policyParameters")
        private String policyParameters;

        /**
         * 规则治理等级，取值：<br>
         * high<br>
         * medium<br>
         * low
         */
        @JsonProperty("policySeverity")
        private String policySeverity;

        /** 策略实例实施范围，默认*代表全部命名空间，否则返回命名空间名称，多个命名空间用逗号分隔 */
        @JsonProperty("policyScope")
        private String policyScope;

        /**
         * 规则治理动作，取值：<br>
         * deny：拦截违规部署<br>
         * warn：告警
         */
        @JsonProperty("policyAction")
        private String policyAction;

        /**
         * 状态，取值：<br>
         * 1：有效<br>
         * 2：删除
         */
        @JsonProperty("status")
        private Integer status;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 创建人 */
        @JsonProperty("createdBy")
        private Long createdBy;

        /** 修改时间 */
        @JsonProperty("modifiedTime")
        private String modifiedTime;

        /** 修改人 */
        @JsonProperty("modifiedBy")
        private Long modifiedBy;

        public Long getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(Long instanceId) {
            this.instanceId = instanceId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public String getPolicyCategory() {
            return this.policyCategory;
        }

        public void setPolicyCategory(String policyCategory) {
            this.policyCategory = policyCategory;
        }

        public String getPolicyDesc() {
            return this.policyDesc;
        }

        public void setPolicyDesc(String policyDesc) {
            this.policyDesc = policyDesc;
        }

        public String getPolicyParameters() {
            return this.policyParameters;
        }

        public void setPolicyParameters(String policyParameters) {
            this.policyParameters = policyParameters;
        }

        public String getPolicySeverity() {
            return this.policySeverity;
        }

        public void setPolicySeverity(String policySeverity) {
            this.policySeverity = policySeverity;
        }

        public String getPolicyScope() {
            return this.policyScope;
        }

        public void setPolicyScope(String policyScope) {
            this.policyScope = policyScope;
        }

        public String getPolicyAction() {
            return this.policyAction;
        }

        public void setPolicyAction(String policyAction) {
            this.policyAction = policyAction;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public Long getCreatedBy() {
            return this.createdBy;
        }

        public void setCreatedBy(Long createdBy) {
            this.createdBy = createdBy;
        }

        public String getModifiedTime() {
            return this.modifiedTime;
        }

        public void setModifiedTime(String modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        public Long getModifiedBy() {
            return this.modifiedBy;
        }

        public void setModifiedBy(Long modifiedBy) {
            this.modifiedBy = modifiedBy;
        }
    }
}
