package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用该接口查询集群一小时内的事件列表。 */
public class CcseListEventsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseListEventsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/apis/events.k8s.io/v1/events",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListEventsResponse send(Credential credential, ListEventsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.labelSelector != null) {
            ctReq.addParam("labelSelector", request.labelSelector);
            request.labelSelector = null;
        }
        if (request.fieldSelector != null) {
            ctReq.addParam("fieldSelector", request.fieldSelector);
            request.fieldSelector = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListEventsResponse.class);
    }

    public static class ListEventsRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10026730/10028695">地域和可用区</a>来了解资源池 获取：
         * <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px;
         * margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&amp;api=5851&amp;data=87">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** Kubernetes labelSelector，可通过label过滤资源；label之间通过“,”分隔，特殊符号要转义为url编码，如“=”写为“%3D” */
        @JsonProperty("labelSelector")
        private String labelSelector;

        /**
         * Kubernetes
         * fieldSelector，可通过field过滤资源；label之间通过“,”分隔，特殊符号要转义为url编码，如“=”写为“%3D”，以下为过滤Event常用的key及其含义：
         * type：事件等级，有Normal和Warning两种等级 regarding.kind：产生事件资源的类型，如Pod、Node等
         * regarding.name：产生事件资源的名称 regarding.namesapce：产生事件资源所在的命名空间
         */
        @JsonProperty("fieldSelector")
        private String fieldSelector;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getLabelSelector() {
            return this.labelSelector;
        }

        public void setLabelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
        }

        public String getFieldSelector() {
            return this.fieldSelector;
        }

        public void setFieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
        }
    }

    public static class ListEventsResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 返回结果，yaml格式事件列表 */
        @JsonProperty("returnObj")
        private String returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(String returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
