package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口查看节点池列表。 */
public class CcseListNodePoolsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseListNodePoolsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/nodepools",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListNodePoolsResponse send(Credential credential, ListNodePoolsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.nodePoolName != null) {
            ctReq.addParam("nodePoolName", request.nodePoolName);
            request.nodePoolName = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListNodePoolsResponse.class);
    }

    public static class ListNodePoolsRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 节点池名称 */
        @JsonProperty("nodePoolName")
        private String nodePoolName;

        /** 当前页码 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 每页条数 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getNodePoolName() {
            return this.nodePoolName;
        }

        public void setNodePoolName(String nodePoolName) {
            this.nodePoolName = nodePoolName;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class ListNodePoolsResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private ListNodePoolsReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ListNodePoolsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListNodePoolsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ListNodePoolsReturnObjResponse {
        /** 记录列表 */
        @JsonProperty("records")
        private List<ListNodePoolsReturnObjRecordsResponse> records;

        /** 总条数 */
        @JsonProperty("total")
        private Integer total;

        /** 每页条数 */
        @JsonProperty("size")
        private Integer size;

        /** 当前页码 */
        @JsonProperty("current")
        private Integer current;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        public List<ListNodePoolsReturnObjRecordsResponse> getRecords() {
            return this.records;
        }

        public void setRecords(List<ListNodePoolsReturnObjRecordsResponse> records) {
            this.records = records;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getCurrent() {
            return this.current;
        }

        public void setCurrent(Integer current) {
            this.current = current;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }
    }

    public static class ListNodePoolsReturnObjRecordsResponse {
        /** 节点池id */
        @JsonProperty("id")
        private String id;

        /** 节点池名称 */
        @JsonProperty("nodePoolName")
        private String nodePoolName;

        /** 计费模式： 1-包年包月 2-按需计费 */
        @JsonProperty("billMode")
        private String billMode;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 节点总数 */
        @JsonProperty("nodeTotalNum")
        private Integer nodeTotalNum;

        /** 正常节点数 */
        @JsonProperty("normalNodeNum")
        private Integer normalNodeNum;

        /** 异常节点数 */
        @JsonProperty("unNormalNodeNum")
        private Integer unNormalNodeNum;

        /** 节点池节点信息 */
        @JsonProperty("nodes")
        private List<ListNodePoolsReturnObjRecordsNodesResponse> nodes;

        /** 运行时 */
        @JsonProperty("runtime")
        private String runtime;

        /** 运行时版本 */
        @JsonProperty("runtimeVersion")
        private String runtimeVersion;

        /** 伸缩组 */
        @JsonProperty("nodeGroup")
        private String nodeGroup;

        /** 节点规格 */
        @JsonProperty("vmSpecName")
        private String vmSpecName;

        /** 节点规格类型 */
        @JsonProperty("vmType")
        private String vmType;

        /** cpu */
        @JsonProperty("cpu")
        private Integer cpu;

        /** 内存 */
        @JsonProperty("memory")
        private Integer memory;

        /** 数据盘 */
        @JsonProperty("dataDisks")
        private List<ListNodePoolsReturnObjRecordsDataDisksResponse> dataDisks;

        /** 状态 */
        @JsonProperty("status")
        private String status;

        /** 最大pod数 */
        @JsonProperty("maxPodNum")
        private Integer maxPodNum;

        /** 标签 */
        @JsonProperty("labels")
        private ListNodePoolsReturnObjRecordsLabelsResponse labels;

        /** 污点 */
        @JsonProperty("taints")
        private List<ListNodePoolsReturnObjRecordsTaintsResponse> taints;

        /** 是否默认 */
        @JsonProperty("isDefault")
        private Boolean isDefault;

        /** 是否自动弹性伸缩 */
        @JsonProperty("enableAutoScale")
        private Boolean enableAutoScale;

        /** 伸缩组最大数量 */
        @JsonProperty("maxNum")
        private Integer maxNum;

        /** 伸缩组最小数量 */
        @JsonProperty("minNum")
        private Integer minNum;

        /** kubelet参数 */
        @JsonProperty("kubeletArgs")
        private ListNodePoolsReturnObjRecordsKubeletArgsResponse kubeletArgs;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 更新时间 */
        @JsonProperty("updatedTime")
        private String updatedTime;

        /** vpc名称 */
        @JsonProperty("vpc")
        private String vpc;

        /** 子网 */
        @JsonProperty("subnetwork")
        private String subnetwork;

        /** 安全组名称 */
        @JsonProperty("secruityGroupName")
        private String secruityGroupName;

        /** 操作系统镜像名称 */
        @JsonProperty("imageName")
        private String imageName;

        /** 操作系统镜像ID */
        @JsonProperty("imageUuid")
        private String imageUuid;

        /** 云主机密码 */
        @JsonProperty("ecsPasswd")
        private String ecsPasswd;

        /** 云主机密码类型 */
        @JsonProperty("loginType")
        private String loginType;

        /** ebm密钥对使用字段 */
        @JsonProperty("keyName")
        private String keyName;

        /** ecs密钥对使用字段 */
        @JsonProperty("keyPairId")
        private String keyPairId;

        /** 节点系统盘类型 */
        @JsonProperty("sysDiskType")
        private String sysDiskType;

        /** 节点系统盘大小 */
        @JsonProperty("sysDiskSize")
        private Integer sysDiskSize;

        /** 自定义kubelet目录 */
        @JsonProperty("kubeletDirectory")
        private String kubeletDirectory;

        /** 自定义容器数据目录 */
        @JsonProperty("containerDataDirectory")
        private String containerDataDirectory;

        /** 部署后执行自定义脚本 */
        @JsonProperty("visibilityPostHostScript")
        private String visibilityPostHostScript;

        /** 部署前执行自定义脚本 */
        @JsonProperty("visibilityHostScript")
        private String visibilityHostScript;

        /** 可用区 */
        @JsonProperty("azInfo")
        private List<ListNodePoolsReturnObjRecordsAzInfoResponse> azInfo;

        /** 子网UUID */
        @JsonProperty("subnetUuid")
        private String subnetUuid;

        /** 节点池类型 */
        @JsonProperty("nodePoolType")
        private Integer nodePoolType;

        /** 订单类型 1-包年包月 2-按需计费 */
        @JsonProperty("billingMode")
        private String billingMode;

        /** 订购时长，cycleType为MONTH时，cycleCount为1表示订购1个月 */
        @JsonProperty("cycleCount")
        private Integer cycleCount;

        /** 订购周期类型 MONTH-月 YEAR-年 */
        @JsonProperty("cycleType")
        private String cycleType;

        /** 是否自动续订 0-否 1-是 */
        @JsonProperty("autoRenewStatus")
        private Integer autoRenewStatus;

        /** 是否自定义节点名称 0-否 1-是 */
        @JsonProperty("definedHostnameEnable")
        private Integer definedHostnameEnable;

        /** 自定义主机名前缀 */
        @JsonProperty("hostNamePrefix")
        private String hostNamePrefix;

        /** 自定义主机名后缀 */
        @JsonProperty("hostNamePostfix")
        private String hostNamePostfix;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNodePoolName() {
            return this.nodePoolName;
        }

        public void setNodePoolName(String nodePoolName) {
            this.nodePoolName = nodePoolName;
        }

        public String getBillMode() {
            return this.billMode;
        }

        public void setBillMode(String billMode) {
            this.billMode = billMode;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getNodeTotalNum() {
            return this.nodeTotalNum;
        }

        public void setNodeTotalNum(Integer nodeTotalNum) {
            this.nodeTotalNum = nodeTotalNum;
        }

        public Integer getNormalNodeNum() {
            return this.normalNodeNum;
        }

        public void setNormalNodeNum(Integer normalNodeNum) {
            this.normalNodeNum = normalNodeNum;
        }

        public Integer getUnNormalNodeNum() {
            return this.unNormalNodeNum;
        }

        public void setUnNormalNodeNum(Integer unNormalNodeNum) {
            this.unNormalNodeNum = unNormalNodeNum;
        }

        public List<ListNodePoolsReturnObjRecordsNodesResponse> getNodes() {
            return this.nodes;
        }

        public void setNodes(List<ListNodePoolsReturnObjRecordsNodesResponse> nodes) {
            this.nodes = nodes;
        }

        public String getRuntime() {
            return this.runtime;
        }

        public void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        public void setRuntimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        public String getNodeGroup() {
            return this.nodeGroup;
        }

        public void setNodeGroup(String nodeGroup) {
            this.nodeGroup = nodeGroup;
        }

        public String getVmSpecName() {
            return this.vmSpecName;
        }

        public void setVmSpecName(String vmSpecName) {
            this.vmSpecName = vmSpecName;
        }

        public String getVmType() {
            return this.vmType;
        }

        public void setVmType(String vmType) {
            this.vmType = vmType;
        }

        public Integer getCpu() {
            return this.cpu;
        }

        public void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        public Integer getMemory() {
            return this.memory;
        }

        public void setMemory(Integer memory) {
            this.memory = memory;
        }

        public List<ListNodePoolsReturnObjRecordsDataDisksResponse> getDataDisks() {
            return this.dataDisks;
        }

        public void setDataDisks(List<ListNodePoolsReturnObjRecordsDataDisksResponse> dataDisks) {
            this.dataDisks = dataDisks;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Integer getMaxPodNum() {
            return this.maxPodNum;
        }

        public void setMaxPodNum(Integer maxPodNum) {
            this.maxPodNum = maxPodNum;
        }

        public ListNodePoolsReturnObjRecordsLabelsResponse getLabels() {
            return this.labels;
        }

        public void setLabels(ListNodePoolsReturnObjRecordsLabelsResponse labels) {
            this.labels = labels;
        }

        public List<ListNodePoolsReturnObjRecordsTaintsResponse> getTaints() {
            return this.taints;
        }

        public void setTaints(List<ListNodePoolsReturnObjRecordsTaintsResponse> taints) {
            this.taints = taints;
        }

        public Boolean getIsDefault() {
            return this.isDefault;
        }

        public void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public Boolean getEnableAutoScale() {
            return this.enableAutoScale;
        }

        public void setEnableAutoScale(Boolean enableAutoScale) {
            this.enableAutoScale = enableAutoScale;
        }

        public Integer getMaxNum() {
            return this.maxNum;
        }

        public void setMaxNum(Integer maxNum) {
            this.maxNum = maxNum;
        }

        public Integer getMinNum() {
            return this.minNum;
        }

        public void setMinNum(Integer minNum) {
            this.minNum = minNum;
        }

        public ListNodePoolsReturnObjRecordsKubeletArgsResponse getKubeletArgs() {
            return this.kubeletArgs;
        }

        public void setKubeletArgs(ListNodePoolsReturnObjRecordsKubeletArgsResponse kubeletArgs) {
            this.kubeletArgs = kubeletArgs;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getUpdatedTime() {
            return this.updatedTime;
        }

        public void setUpdatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
        }

        public String getVpc() {
            return this.vpc;
        }

        public void setVpc(String vpc) {
            this.vpc = vpc;
        }

        public String getSubnetwork() {
            return this.subnetwork;
        }

        public void setSubnetwork(String subnetwork) {
            this.subnetwork = subnetwork;
        }

        public String getSecruityGroupName() {
            return this.secruityGroupName;
        }

        public void setSecruityGroupName(String secruityGroupName) {
            this.secruityGroupName = secruityGroupName;
        }

        public String getImageName() {
            return this.imageName;
        }

        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public String getImageUuid() {
            return this.imageUuid;
        }

        public void setImageUuid(String imageUuid) {
            this.imageUuid = imageUuid;
        }

        public String getEcsPasswd() {
            return this.ecsPasswd;
        }

        public void setEcsPasswd(String ecsPasswd) {
            this.ecsPasswd = ecsPasswd;
        }

        public String getLoginType() {
            return this.loginType;
        }

        public void setLoginType(String loginType) {
            this.loginType = loginType;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public String getKeyPairId() {
            return this.keyPairId;
        }

        public void setKeyPairId(String keyPairId) {
            this.keyPairId = keyPairId;
        }

        public String getSysDiskType() {
            return this.sysDiskType;
        }

        public void setSysDiskType(String sysDiskType) {
            this.sysDiskType = sysDiskType;
        }

        public Integer getSysDiskSize() {
            return this.sysDiskSize;
        }

        public void setSysDiskSize(Integer sysDiskSize) {
            this.sysDiskSize = sysDiskSize;
        }

        public String getKubeletDirectory() {
            return this.kubeletDirectory;
        }

        public void setKubeletDirectory(String kubeletDirectory) {
            this.kubeletDirectory = kubeletDirectory;
        }

        public String getContainerDataDirectory() {
            return this.containerDataDirectory;
        }

        public void setContainerDataDirectory(String containerDataDirectory) {
            this.containerDataDirectory = containerDataDirectory;
        }

        public String getVisibilityPostHostScript() {
            return this.visibilityPostHostScript;
        }

        public void setVisibilityPostHostScript(String visibilityPostHostScript) {
            this.visibilityPostHostScript = visibilityPostHostScript;
        }

        public String getVisibilityHostScript() {
            return this.visibilityHostScript;
        }

        public void setVisibilityHostScript(String visibilityHostScript) {
            this.visibilityHostScript = visibilityHostScript;
        }

        public List<ListNodePoolsReturnObjRecordsAzInfoResponse> getAzInfo() {
            return this.azInfo;
        }

        public void setAzInfo(List<ListNodePoolsReturnObjRecordsAzInfoResponse> azInfo) {
            this.azInfo = azInfo;
        }

        public String getSubnetUuid() {
            return this.subnetUuid;
        }

        public void setSubnetUuid(String subnetUuid) {
            this.subnetUuid = subnetUuid;
        }

        public Integer getNodePoolType() {
            return this.nodePoolType;
        }

        public void setNodePoolType(Integer nodePoolType) {
            this.nodePoolType = nodePoolType;
        }

        public String getBillingMode() {
            return this.billingMode;
        }

        public void setBillingMode(String billingMode) {
            this.billingMode = billingMode;
        }

        public Integer getCycleCount() {
            return this.cycleCount;
        }

        public void setCycleCount(Integer cycleCount) {
            this.cycleCount = cycleCount;
        }

        public String getCycleType() {
            return this.cycleType;
        }

        public void setCycleType(String cycleType) {
            this.cycleType = cycleType;
        }

        public Integer getAutoRenewStatus() {
            return this.autoRenewStatus;
        }

        public void setAutoRenewStatus(Integer autoRenewStatus) {
            this.autoRenewStatus = autoRenewStatus;
        }

        public Integer getDefinedHostnameEnable() {
            return this.definedHostnameEnable;
        }

        public void setDefinedHostnameEnable(Integer definedHostnameEnable) {
            this.definedHostnameEnable = definedHostnameEnable;
        }

        public String getHostNamePrefix() {
            return this.hostNamePrefix;
        }

        public void setHostNamePrefix(String hostNamePrefix) {
            this.hostNamePrefix = hostNamePrefix;
        }

        public String getHostNamePostfix() {
            return this.hostNamePostfix;
        }

        public void setHostNamePostfix(String hostNamePostfix) {
            this.hostNamePostfix = hostNamePostfix;
        }
    }

    public static class ListNodePoolsReturnObjRecordsNodesResponse {
        /** 集群ID */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 节点名称 */
        @JsonProperty("nodeName")
        private String nodeName;

        /**
         * 节点类型，取值：<br>
         * 1：master <br>
         * 2：slave
         */
        @JsonProperty("nodeType")
        private Integer nodeType;

        /**
         * 节点状态，取值：<br>
         * normal：健康。<br>
         * abnormal：异常。<br>
         * expulsion：驱逐中。
         */
        @JsonProperty("nodeStatus")
        private String nodeStatus;

        /**
         * 是否调度，取值： 1：是。 <br>
         * 0：否。
         */
        @JsonProperty("isSchedule")
        private Integer isSchedule;

        /**
         * 是否驱逐，取值： 1：是。 <br>
         * 0：否。
         */
        @JsonProperty("isEvict")
        private Integer isEvict;

        /** docker数据目录 */
        @JsonProperty("dockerDataPath")
        private String dockerDataPath;

        /** 创建时间。 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 主机管理ip。 */
        @JsonProperty("hostIp")
        private String hostIp;

        /** 主机管理ipv6。 */
        @JsonProperty("hostIpv6")
        private String hostIpv6;

        /** 主机业务ip。 */
        @JsonProperty("hostExtraIp")
        private String hostExtraIp;

        /** 主机业务ipv6。 */
        @JsonProperty("hostExtraIpv6")
        private String hostExtraIpv6;

        /** cpu核数 */
        @JsonProperty("cpu")
        private String cpu;

        /** cpu使用率% */
        @JsonProperty("cpuUseRate")
        private Integer cpuUseRate;

        /** 内存 */
        @JsonProperty("memory")
        private String memory;

        /** 内存使用率% */
        @JsonProperty("memoryUseRate")
        private Integer memoryUseRate;

        /** 磁盘GiB */
        @JsonProperty("disk")
        private String disk;

        /** 磁盘使用率% */
        @JsonProperty("diskUseRate")
        private Integer diskUseRate;

        /** Kubelet 版本 */
        @JsonProperty("kubeletVersion")
        private String kubeletVersion;

        /** Pod CIDR */
        @JsonProperty("podCidr")
        private String podCidr;

        /** 内核版本 */
        @JsonProperty("kernelVersion")
        private String kernelVersion;

        /** OS 镜像 */
        @JsonProperty("osImageVersion")
        private String osImageVersion;

        /** KubeProxy 版本 */
        @JsonProperty("kubeProxyVersion")
        private String kubeProxyVersion;

        /** 容器版本 */
        @JsonProperty("dockerVersion")
        private String dockerVersion;

        /**
         * 是否安全节点，取值：<br>
         * 1：是。 <br>
         * 0：否。
         */
        @JsonProperty("isSecure")
        private Integer isSecure;

        /** 污点 */
        @JsonProperty("taints")
        private List<ListNodePoolsReturnObjRecordsNodesTaintsResponse> taints;

        /** 渠道标签 */
        @JsonProperty("channelLabel")
        private String channelLabel;

        /** 可用区名称 */
        @JsonProperty("zoneName")
        private String zoneName;

        /** 云主机id */
        @JsonProperty("cloudHostId")
        private String cloudHostId;

        /** 标签 */
        @JsonProperty("labels")
        private ListNodePoolsReturnObjRecordsNodesLabelsResponse labels;

        /** paas平台云主机id */
        @JsonProperty("ecsId")
        private String ecsId;

        /** 节点规格名称 */
        @JsonProperty("vmSpecName")
        private String vmSpecName;

        /** 架构 */
        @JsonProperty("architecture")
        private String architecture;

        /** 可用区编码 */
        @JsonProperty("zoneCode")
        private String zoneCode;

        /** 集群状态 */
        @JsonProperty("bizState")
        private Integer bizState;

        /** 是否显示机房信息 */
        @JsonProperty("needShowHostRoom")
        private Boolean needShowHostRoom;

        /** 机房名称 */
        @JsonProperty("roomName")
        private String roomName;

        /** 机柜编码 */
        @JsonProperty("frameCode")
        private String frameCode;

        /** 物理位置 */
        @JsonProperty("physicalPosition")
        private String physicalPosition;

        /** 机房信息 */
        @JsonProperty("roomInfo")
        private String roomInfo;

        /** 是否为bootstrap节点 */
        @JsonProperty("isBootstrap")
        private Boolean isBootstrap;

        /** host类型 */
        @JsonProperty("hostType")
        private String hostType;

        /** 资源id */
        @JsonProperty("resourceId")
        private String resourceId;

        /** 开启/关闭节点缩容保护 */
        @JsonProperty("nodeScaleDownProject")
        private Boolean nodeScaleDownProject;

        /** 登陆类型 */
        @JsonProperty("loginType")
        private String loginType;

        /** 虚拟节点ID */
        @JsonProperty("virtualNodeId")
        private String virtualNodeId;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public Integer getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(Integer nodeType) {
            this.nodeType = nodeType;
        }

        public String getNodeStatus() {
            return this.nodeStatus;
        }

        public void setNodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
        }

        public Integer getIsSchedule() {
            return this.isSchedule;
        }

        public void setIsSchedule(Integer isSchedule) {
            this.isSchedule = isSchedule;
        }

        public Integer getIsEvict() {
            return this.isEvict;
        }

        public void setIsEvict(Integer isEvict) {
            this.isEvict = isEvict;
        }

        public String getDockerDataPath() {
            return this.dockerDataPath;
        }

        public void setDockerDataPath(String dockerDataPath) {
            this.dockerDataPath = dockerDataPath;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getHostIp() {
            return this.hostIp;
        }

        public void setHostIp(String hostIp) {
            this.hostIp = hostIp;
        }

        public String getHostIpv6() {
            return this.hostIpv6;
        }

        public void setHostIpv6(String hostIpv6) {
            this.hostIpv6 = hostIpv6;
        }

        public String getHostExtraIp() {
            return this.hostExtraIp;
        }

        public void setHostExtraIp(String hostExtraIp) {
            this.hostExtraIp = hostExtraIp;
        }

        public String getHostExtraIpv6() {
            return this.hostExtraIpv6;
        }

        public void setHostExtraIpv6(String hostExtraIpv6) {
            this.hostExtraIpv6 = hostExtraIpv6;
        }

        public String getCpu() {
            return this.cpu;
        }

        public void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public Integer getCpuUseRate() {
            return this.cpuUseRate;
        }

        public void setCpuUseRate(Integer cpuUseRate) {
            this.cpuUseRate = cpuUseRate;
        }

        public String getMemory() {
            return this.memory;
        }

        public void setMemory(String memory) {
            this.memory = memory;
        }

        public Integer getMemoryUseRate() {
            return this.memoryUseRate;
        }

        public void setMemoryUseRate(Integer memoryUseRate) {
            this.memoryUseRate = memoryUseRate;
        }

        public String getDisk() {
            return this.disk;
        }

        public void setDisk(String disk) {
            this.disk = disk;
        }

        public Integer getDiskUseRate() {
            return this.diskUseRate;
        }

        public void setDiskUseRate(Integer diskUseRate) {
            this.diskUseRate = diskUseRate;
        }

        public String getKubeletVersion() {
            return this.kubeletVersion;
        }

        public void setKubeletVersion(String kubeletVersion) {
            this.kubeletVersion = kubeletVersion;
        }

        public String getPodCidr() {
            return this.podCidr;
        }

        public void setPodCidr(String podCidr) {
            this.podCidr = podCidr;
        }

        public String getKernelVersion() {
            return this.kernelVersion;
        }

        public void setKernelVersion(String kernelVersion) {
            this.kernelVersion = kernelVersion;
        }

        public String getOsImageVersion() {
            return this.osImageVersion;
        }

        public void setOsImageVersion(String osImageVersion) {
            this.osImageVersion = osImageVersion;
        }

        public String getKubeProxyVersion() {
            return this.kubeProxyVersion;
        }

        public void setKubeProxyVersion(String kubeProxyVersion) {
            this.kubeProxyVersion = kubeProxyVersion;
        }

        public String getDockerVersion() {
            return this.dockerVersion;
        }

        public void setDockerVersion(String dockerVersion) {
            this.dockerVersion = dockerVersion;
        }

        public Integer getIsSecure() {
            return this.isSecure;
        }

        public void setIsSecure(Integer isSecure) {
            this.isSecure = isSecure;
        }

        public List<ListNodePoolsReturnObjRecordsNodesTaintsResponse> getTaints() {
            return this.taints;
        }

        public void setTaints(List<ListNodePoolsReturnObjRecordsNodesTaintsResponse> taints) {
            this.taints = taints;
        }

        public String getChannelLabel() {
            return this.channelLabel;
        }

        public void setChannelLabel(String channelLabel) {
            this.channelLabel = channelLabel;
        }

        public String getZoneName() {
            return this.zoneName;
        }

        public void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public String getCloudHostId() {
            return this.cloudHostId;
        }

        public void setCloudHostId(String cloudHostId) {
            this.cloudHostId = cloudHostId;
        }

        public ListNodePoolsReturnObjRecordsNodesLabelsResponse getLabels() {
            return this.labels;
        }

        public void setLabels(ListNodePoolsReturnObjRecordsNodesLabelsResponse labels) {
            this.labels = labels;
        }

        public String getEcsId() {
            return this.ecsId;
        }

        public void setEcsId(String ecsId) {
            this.ecsId = ecsId;
        }

        public String getVmSpecName() {
            return this.vmSpecName;
        }

        public void setVmSpecName(String vmSpecName) {
            this.vmSpecName = vmSpecName;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public String getZoneCode() {
            return this.zoneCode;
        }

        public void setZoneCode(String zoneCode) {
            this.zoneCode = zoneCode;
        }

        public Integer getBizState() {
            return this.bizState;
        }

        public void setBizState(Integer bizState) {
            this.bizState = bizState;
        }

        public Boolean getNeedShowHostRoom() {
            return this.needShowHostRoom;
        }

        public void setNeedShowHostRoom(Boolean needShowHostRoom) {
            this.needShowHostRoom = needShowHostRoom;
        }

        public String getRoomName() {
            return this.roomName;
        }

        public void setRoomName(String roomName) {
            this.roomName = roomName;
        }

        public String getFrameCode() {
            return this.frameCode;
        }

        public void setFrameCode(String frameCode) {
            this.frameCode = frameCode;
        }

        public String getPhysicalPosition() {
            return this.physicalPosition;
        }

        public void setPhysicalPosition(String physicalPosition) {
            this.physicalPosition = physicalPosition;
        }

        public String getRoomInfo() {
            return this.roomInfo;
        }

        public void setRoomInfo(String roomInfo) {
            this.roomInfo = roomInfo;
        }

        public Boolean getIsBootstrap() {
            return this.isBootstrap;
        }

        public void setIsBootstrap(Boolean isBootstrap) {
            this.isBootstrap = isBootstrap;
        }

        public String getHostType() {
            return this.hostType;
        }

        public void setHostType(String hostType) {
            this.hostType = hostType;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public Boolean getNodeScaleDownProject() {
            return this.nodeScaleDownProject;
        }

        public void setNodeScaleDownProject(Boolean nodeScaleDownProject) {
            this.nodeScaleDownProject = nodeScaleDownProject;
        }

        public String getLoginType() {
            return this.loginType;
        }

        public void setLoginType(String loginType) {
            this.loginType = loginType;
        }

        public String getVirtualNodeId() {
            return this.virtualNodeId;
        }

        public void setVirtualNodeId(String virtualNodeId) {
            this.virtualNodeId = virtualNodeId;
        }
    }

    public static class ListNodePoolsReturnObjRecordsDataDisksResponse {
        /** 数据盘规格名称 */
        @JsonProperty("diskSpecName")
        private String diskSpecName;

        /** 数据盘大小 */
        @JsonProperty("size")
        private Long size;

        public String getDiskSpecName() {
            return this.diskSpecName;
        }

        public void setDiskSpecName(String diskSpecName) {
            this.diskSpecName = diskSpecName;
        }

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long size) {
            this.size = size;
        }
    }

    public static class ListNodePoolsReturnObjRecordsLabelsResponse {}

    public static class ListNodePoolsReturnObjRecordsTaintsResponse {
        /** 键 */
        @JsonProperty("key")
        private String key;

        /** 值 */
        @JsonProperty("value")
        private String value;

        /** 策略 */
        @JsonProperty("effect")
        private String effect;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getEffect() {
            return this.effect;
        }

        public void setEffect(String effect) {
            this.effect = effect;
        }
    }

    public static class ListNodePoolsReturnObjRecordsKubeletArgsResponse {}

    public static class ListNodePoolsReturnObjRecordsAzInfoResponse {
        /** 可用区ID */
        @JsonProperty("azId")
        private Long azId;

        /** 可用区Name */
        @JsonProperty("azName")
        private String azName;

        public Long getAzId() {
            return this.azId;
        }

        public void setAzId(Long azId) {
            this.azId = azId;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }
    }

    public static class ListNodePoolsReturnObjRecordsNodesTaintsResponse {
        /** 键 */
        @JsonProperty("key")
        private String key;

        /** 值 */
        @JsonProperty("value")
        private String value;

        /** 策略 */
        @JsonProperty("effect")
        private String effect;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getEffect() {
            return this.effect;
        }

        public void setEffect(String effect) {
            this.effect = effect;
        }
    }

    public static class ListNodePoolsReturnObjRecordsNodesLabelsResponse {}
}
