package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口可查询插件实例列表。 */
public class CcseListPluginInstancesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseListPluginInstancesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/plugininstance/page",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListPluginInstancesResponse send(
            Credential credential, ListPluginInstancesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.namespace != null) {
            ctReq.addParam("namespace", request.namespace);
            request.namespace = null;
        }
        if (request.chartName != null) {
            ctReq.addParam("chartName", request.chartName);
            request.chartName = null;
        }
        if (request.instanceName != null) {
            ctReq.addParam("instanceName", request.instanceName);
            request.instanceName = null;
        }
        if (request.listAll != null) {
            ctReq.addParam("listAll", String.valueOf(request.listAll));
            request.listAll = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListPluginInstancesResponse.class);
    }

    public static class ListPluginInstancesRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 当前页码 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 每页条数 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 命名空间名称 */
        @JsonProperty("namespace")
        private String namespace;

        /** chart名称 */
        @JsonProperty("chartName")
        private String chartName;

        /** 插件名称 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 是否列举全部 */
        @JsonProperty("listAll")
        private Boolean listAll;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getChartName() {
            return this.chartName;
        }

        public void setChartName(String chartName) {
            this.chartName = chartName;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public Boolean getListAll() {
            return this.listAll;
        }

        public void setListAll(Boolean listAll) {
            this.listAll = listAll;
        }
    }

    public static class ListPluginInstancesResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 分页查询结果对象 */
        @JsonProperty("returnObj")
        private ListPluginInstancesReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ListPluginInstancesReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListPluginInstancesReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ListPluginInstancesReturnObjResponse {
        /** 记录列表 */
        @JsonProperty("records")
        private List<ListPluginInstancesReturnObjRecordsResponse> records;

        /** 总条数 */
        @JsonProperty("total")
        private Integer total;

        /** 每页条数 */
        @JsonProperty("size")
        private Integer size;

        /** 当前页码 */
        @JsonProperty("current")
        private Integer current;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        public List<ListPluginInstancesReturnObjRecordsResponse> getRecords() {
            return this.records;
        }

        public void setRecords(List<ListPluginInstancesReturnObjRecordsResponse> records) {
            this.records = records;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getCurrent() {
            return this.current;
        }

        public void setCurrent(Integer current) {
            this.current = current;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }
    }

    public static class ListPluginInstancesReturnObjRecordsResponse {
        /** 实例名称。 */
        @JsonProperty("name")
        private String name;

        /** 版本 */
        @JsonProperty("revision")
        private String revision;

        /** 命名空间 */
        @JsonProperty("namespace")
        private String namespace;

        /** 更新时间 */
        @JsonProperty("updated")
        private String updated;

        /**
         * 状态。取值范围：uninstalled未安装、deployed已部署、failed失败、pending-upgrade待升级、pending-rollback待回滚、uninstalling已卸载、uninstalled已卸载完成、pending-install安装中
         */
        @JsonProperty("status")
        private String status;

        /** Chart名称和版本 */
        @JsonProperty("chart")
        private String chart;

        /** 版本 */
        @JsonProperty("appVersion")
        private String appVersion;

        /** 集群ID */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 仓库ID */
        @JsonProperty("repositoryId")
        private String repositoryId;

        /** Chart名称 */
        @JsonProperty("chartName")
        private String chartName;

        /** Chart版本 */
        @JsonProperty("chartVersion")
        private String chartVersion;

        /** Chart地址 */
        @JsonProperty("chartUrl")
        private String chartUrl;

        /** icon地址 */
        @JsonProperty("icon")
        private String icon;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 下一版本 */
        @JsonProperty("nextVersion")
        private String nextVersion;

        /** 模板类型 */
        @JsonProperty("templateName")
        private String templateName;

        /** kubeConfig路径 */
        @JsonProperty("kubeConfigPath")
        private String kubeConfigPath;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getUpdated() {
            return this.updated;
        }

        public void setUpdated(String updated) {
            this.updated = updated;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getChart() {
            return this.chart;
        }

        public void setChart(String chart) {
            this.chart = chart;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRepositoryId() {
            return this.repositoryId;
        }

        public void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        public String getChartName() {
            return this.chartName;
        }

        public void setChartName(String chartName) {
            this.chartName = chartName;
        }

        public String getChartVersion() {
            return this.chartVersion;
        }

        public void setChartVersion(String chartVersion) {
            this.chartVersion = chartVersion;
        }

        public String getChartUrl() {
            return this.chartUrl;
        }

        public void setChartUrl(String chartUrl) {
            this.chartUrl = chartUrl;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getNextVersion() {
            return this.nextVersion;
        }

        public void setNextVersion(String nextVersion) {
            this.nextVersion = nextVersion;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public String getKubeConfigPath() {
            return this.kubeConfigPath;
        }

        public void setKubeConfigPath(String kubeConfigPath) {
            this.kubeConfigPath = kubeConfigPath;
        }
    }
}
