package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口查询巡检报告详情 */
public class CcseQueryInspectionReportDetailApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseQueryInspectionReportDetailApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/inspection/reports/{reportId}",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryInspectionReportDetailResponse send(
            Credential credential, QueryInspectionReportDetailRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        if (request.reportId != null) {
            builder.replaceUrl("reportId", request.reportId);
            request.reportId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", request.pageNow);
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", request.pageSize);
            request.pageSize = null;
        }
        if (request.namespace != null) {
            ctReq.addParam("namespace", request.namespace);
            request.namespace = null;
        }
        if (request.resourceType != null) {
            ctReq.addParam("resourceType", request.resourceType);
            request.resourceType = null;
        }
        if (request.level != null) {
            ctReq.addParam("level", request.level);
            request.level = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryInspectionReportDetailResponse.class);
    }

    public static class QueryInspectionReportDetailRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 巡检报告ID */
        @JsonProperty("reportId")
        private String reportId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 当前页码 */
        @JsonProperty("pageNow")
        private String pageNow;

        /** 每页条数 */
        @JsonProperty("pageSize")
        private String pageSize;

        /** 过滤风险项的命名空间 */
        @JsonProperty("namespace")
        private String namespace;

        /**
         * 过滤风险项的资源类型，多种资源类型用“,”分隔，支持的资源类型： 集群节点：Node
         * 集群工作负载：Deployment,ReplicaSet,DaemonSet,StatefulSet,Job 集群Pod：Pod 集群权限：Role,ClusterRole
         * 集群证书：Cert 集群异常事件：Event
         */
        @JsonProperty("resourceType")
        private String resourceType;

        /** 过滤风险项的级别，多种级别用“,”分隔，支持的级别 danger：高危 warning：警告 ignore：提示 */
        @JsonProperty("level")
        private String level;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getReportId() {
            return this.reportId;
        }

        public void setReportId(String reportId) {
            this.reportId = reportId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(String pageNow) {
            this.pageNow = pageNow;
        }

        public String getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }
    }

    public static class QueryInspectionReportDetailResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryInspectionReportDetailReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public QueryInspectionReportDetailReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryInspectionReportDetailReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryInspectionReportDetailReturnObjResponse {
        /** 巡检报告ID */
        @JsonProperty("reportId")
        private String reportId;

        /** 巡检开始时间 */
        @JsonProperty("startTime")
        private String startTime;

        /** 巡检结束时间 */
        @JsonProperty("endTime")
        private String endTime;

        /** 巡检风险项 */
        @JsonProperty("items")
        private QueryInspectionReportDetailReturnObjItemsResponse items;

        public String getReportId() {
            return this.reportId;
        }

        public void setReportId(String reportId) {
            this.reportId = reportId;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public QueryInspectionReportDetailReturnObjItemsResponse getItems() {
            return this.items;
        }

        public void setItems(QueryInspectionReportDetailReturnObjItemsResponse items) {
            this.items = items;
        }
    }

    public static class QueryInspectionReportDetailReturnObjItemsResponse {
        /** 记录列表 */
        @JsonProperty("records")
        private List<QueryInspectionReportDetailReturnObjItemsRecordsResponse> records;

        /** 总条数 */
        @JsonProperty("total")
        private Integer total;

        /** 每页条数 */
        @JsonProperty("size")
        private Integer size;

        /** 当前页码 */
        @JsonProperty("current")
        private Integer current;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        public List<QueryInspectionReportDetailReturnObjItemsRecordsResponse> getRecords() {
            return this.records;
        }

        public void setRecords(
                List<QueryInspectionReportDetailReturnObjItemsRecordsResponse> records) {
            this.records = records;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getCurrent() {
            return this.current;
        }

        public void setCurrent(Integer current) {
            this.current = current;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }
    }

    public static class QueryInspectionReportDetailReturnObjItemsRecordsResponse {
        /** 命名空间 */
        @JsonProperty("namespace")
        private String namespace;

        /** 资源类型 */
        @JsonProperty("resourceType")
        private String resourceType;

        /** 资源名 */
        @JsonProperty("resourceName")
        private String resourceName;

        /** 风险项级别 */
        @JsonProperty("level")
        private String level;

        /** 风险检查项 */
        @JsonProperty("message")
        private String message;

        /** 异常影响 */
        @JsonProperty("describe")
        private String describe;

        /** 解决方案 */
        @JsonProperty("suggest")
        private String suggest;

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescribe() {
            return this.describe;
        }

        public void setDescribe(String describe) {
            this.describe = describe;
        }

        public String getSuggest() {
            return this.suggest;
        }

        public void setSuggest(String suggest) {
            this.suggest = suggest;
        }
    }
}
