package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口修改集群。 */
public class CcseUpdateClusterApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseUpdateClusterApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "PUT", "/v2/cce/clusters/{clusterId}", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateClusterResponse send(Credential credential, UpdateClusterRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateClusterResponse.class);
    }

    public static class UpdateClusterRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 集群显示名称 */
        @JsonProperty("clusterAlias")
        private String clusterAlias;

        /** 集群描述 */
        @JsonProperty("clusterDesc")
        private String clusterDesc;

        /** 自定义SAN */
        @JsonProperty("customSan")
        private UpdateClusterCustomSanRequest customSan;

        /** 服务起始端口，取值范围[20106, 32767] */
        @JsonProperty("startPort")
        private Integer startPort;

        /** 服务结束端口，取值范围[20106, 32767] */
        @JsonProperty("endPort")
        private Integer endPort;

        /** 节点默认安全组ID */
        @JsonProperty("securityGroupId")
        private String securityGroupId;

        /** cubecni插件网络配置 */
        @JsonProperty("cubecni")
        private UpdateClusterCubecniRequest cubecni;

        /**
         * 企业项目id，企业项目管理服务提供统一的云资源按企业项目管理，以及企业项目内的资源管理，成员管理。您可以通过查看<a
         * href="https://www.ctyun.cn/document/10017248/10017961">创建企业项目</a>了解如何创建企业项目
         */
        @JsonProperty("projectId")
        private String projectId;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getClusterAlias() {
            return this.clusterAlias;
        }

        public void setClusterAlias(String clusterAlias) {
            this.clusterAlias = clusterAlias;
        }

        public String getClusterDesc() {
            return this.clusterDesc;
        }

        public void setClusterDesc(String clusterDesc) {
            this.clusterDesc = clusterDesc;
        }

        public UpdateClusterCustomSanRequest getCustomSan() {
            return this.customSan;
        }

        public void setCustomSan(UpdateClusterCustomSanRequest customSan) {
            this.customSan = customSan;
        }

        public Integer getStartPort() {
            return this.startPort;
        }

        public void setStartPort(Integer startPort) {
            this.startPort = startPort;
        }

        public Integer getEndPort() {
            return this.endPort;
        }

        public void setEndPort(Integer endPort) {
            this.endPort = endPort;
        }

        public String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        public UpdateClusterCubecniRequest getCubecni() {
            return this.cubecni;
        }

        public void setCubecni(UpdateClusterCubecniRequest cubecni) {
            this.cubecni = cubecni;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }
    }

    public static class UpdateClusterCustomSanRequest {
        /** 操作类型，支持：overwrite */
        @JsonProperty("action")
        private String action;

        /** SAN列表 */
        @JsonProperty("values")
        private List<String> values;

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }
    }

    public static class UpdateClusterCubecniRequest {
        /** 最小缓存辅助IP数，取值范围[0, 60]，不大于maxPoolSize */
        @JsonProperty("minPoolSize")
        private Integer minPoolSize;

        /** 最大缓存辅助IP数，取值范围[0, 60]，不小于minPoolSize */
        @JsonProperty("maxPoolSize")
        private Integer maxPoolSize;

        /** 新增Pod子网ID列表 */
        @JsonProperty("appendSubnets")
        private List<String> appendSubnets;

        public Integer getMinPoolSize() {
            return this.minPoolSize;
        }

        public void setMinPoolSize(Integer minPoolSize) {
            this.minPoolSize = minPoolSize;
        }

        public Integer getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public void setMaxPoolSize(Integer maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public List<String> getAppendSubnets() {
            return this.appendSubnets;
        }

        public void setAppendSubnets(List<String> appendSubnets) {
            this.appendSubnets = appendSubnets;
        }
    }

    public static class UpdateClusterResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private Boolean returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Boolean getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(Boolean returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
