package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 更新节点弹性伸缩策略 */
public class CcseUpdateClusterAutoscalerPolicyApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseUpdateClusterAutoscalerPolicyApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "PUT",
                        "/v2/cce/clusters/{clusterId}/apis/autoscaler.ccse.ctyun.cn/v1/horizontalnodeautoscalers/{name}",
                        "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateClusterAutoscalerPolicyResponse send(
            Credential credential, UpdateClusterAutoscalerPolicyRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        if (request.name != null) {
            builder.replaceUrl("name", request.name);
            request.name = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeString(request.textPlainDataString, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateClusterAutoscalerPolicyResponse.class);
    }

    public static class UpdateClusterAutoscalerPolicyRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         * 如：
         * /v1.2/cce/clusters/{clusterId}/apis/autoscaler.ccse.ctyun.cn/v1/horizontalnodeautoscaler/{name}
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 节点弹性伸缩策略名称 如：
         * /v1.2/cce/clusters/{clusterId}/apis/autoscaler.ccse.ctyun.cn/v1/horizontalnodeautoscaler/{name}
         */
        @JsonProperty("name")
        private String name;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10026730/10028695">地域和可用区</a>来了解资源池 获取：
         * <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px;
         * margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&amp;api=5851&amp;data=87">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 字符串类型的yaml资源 */
        @JsonProperty("textPlainDataString")
        private String textPlainDataString;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTextPlainDataString() {
            return this.textPlainDataString;
        }

        public void setTextPlainDataString(String textPlainDataString) {
            this.textPlainDataString = textPlainDataString;
        }
    }

    public static class UpdateClusterAutoscalerPolicyResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private String returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(String returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
