package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用该接口变更托管集群控制面规格。 */
public class CcseUpdateClusterSeriesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseUpdateClusterSeriesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "PUT",
                        "/v2/cce/clusters/{clusterId}/series",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateClusterSeriesResponse send(
            Credential credential, UpdateClusterSeriesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateClusterSeriesResponse.class);
    }

    public static class UpdateClusterSeriesRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 控制面规格，managedbase代表单实例，managedpro代表高可用 */
        @JsonProperty("seriesType")
        private String seriesType;

        /** 集群节点规模,managedbase中包含10节点规模，managedpro中包含50、200、1000、2000节点规模 */
        @JsonProperty("nodeScale")
        private String nodeScale;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getSeriesType() {
            return this.seriesType;
        }

        public void setSeriesType(String seriesType) {
            this.seriesType = seriesType;
        }

        public String getNodeScale() {
            return this.nodeScale;
        }

        public void setNodeScale(String nodeScale) {
            this.nodeScale = nodeScale;
        }
    }

    public static class UpdateClusterSeriesResponse {
        /** 请求结果编码 */
        @JsonProperty("code")
        private Integer code;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 订单实例 */
        @JsonProperty("returnObj")
        private UpdateClusterSeriesReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getCode() {
            return this.code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpdateClusterSeriesReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateClusterSeriesReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class UpdateClusterSeriesReturnObjResponse {
        /** 订单id */
        @JsonProperty("orderId")
        private String orderId;

        /** 订单编码 */
        @JsonProperty("orderNo")
        private String orderNo;

        /** 集群实例id */
        @JsonProperty("prodInstId")
        private String prodInstId;

        public String getOrderId() {
            return this.orderId;
        }

        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        public String getOrderNo() {
            return this.orderNo;
        }

        public void setOrderNo(String orderNo) {
            this.orderNo = orderNo;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }
    }
}
