package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Map;

/** 调用该接口配置节点池Kubelet。 */
public class CcseUpdateNodePoolKubeletConfigApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseUpdateNodePoolKubeletConfigApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/cce/clusters/{clusterId}/nodepool/{nodePoolId}/kubeletconfig/update",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateNodePoolKubeletConfigResponse send(
            Credential credential, UpdateNodePoolKubeletConfigRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        if (request.nodePoolId != null) {
            builder.replaceUrl("nodePoolId", request.nodePoolId);
            request.nodePoolId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateNodePoolKubeletConfigResponse.class);
    }

    public static class UpdateNodePoolKubeletConfigRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 节点池ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("nodePoolId")
        private String nodePoolId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * kubelet的相关配置参数，您可以查看<a href="https://www.ctyun.cn/document/10083472/11068789"
         * target="_blank">kubelet配置参数</a>
         */
        @JsonProperty("kubeletArgs")
        private Map<String,Object> kubeletArgs;

        /** 并行度，默认值是1 */
        @JsonProperty("parallelNumber")
        private Integer parallelNumber;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getNodePoolId() {
            return this.nodePoolId;
        }

        public void setNodePoolId(String nodePoolId) {
            this.nodePoolId = nodePoolId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Map<String,Object>  getKubeletArgs() {
            return this.kubeletArgs;
        }

        public void setKubeletArgs(Map<String,Object>  kubeletArgs) {
            this.kubeletArgs = kubeletArgs;
        }

        public Integer getParallelNumber() {
            return this.parallelNumber;
        }

        public void setParallelNumber(Integer parallelNumber) {
            this.parallelNumber = parallelNumber;
        }
    }

    public static class UpdateNodePoolKubeletConfigKubeletArgsRequest {}

    public static class UpdateNodePoolKubeletConfigResponse {
        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 响应对象 */
        @JsonProperty("returnObj")
        private UpdateNodePoolKubeletConfigReturnObjResponse returnObj;

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpdateNodePoolKubeletConfigReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateNodePoolKubeletConfigReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateNodePoolKubeletConfigReturnObjResponse {
        /** 任务ID */
        @JsonProperty("taskId")
        private String taskId;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }
}
