package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequestException;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.junit.jupiter.api.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CcseCreateClusterApiTest {
    @Test
    void send() throws CtyunRequestException {
        CtyunClient ctyunClient = CtyunClient.defaultClient();
        Credential credential = new Credential("<YOUR_AK>", "<YOUR_SK>");
        // Credential credential = Credential.credentialFromEnv();
        Apis apis = new Apis("<YOUR_ENDPOINT>", ctyunClient);

        CcseCreateClusterApi.CreateClusterRequest request =
                new CcseCreateClusterApi.CreateClusterRequest();
        request.setRegionId("b342b77ef26b11ecb0ac0242ac110002");
        CcseCreateClusterApi.CreateClusterClusterBaseInfoRequest request1 =
                new CcseCreateClusterApi.CreateClusterClusterBaseInfoRequest();
        request1.setClusterName("test-123");
        request1.setClusterAlias("cce-test");
        request1.setClusterSeries("cce.standard");
        request1.setProjectId("0");
        request1.setBillMode("1");
        request1.setCycleType("3");
        request1.setCycleCnt("1");
        request1.setAutoRenewStatus(false);
        request1.setClusterVersion("1.31.6");
        request1.setSeriesType("managedpro");
        request1.setNodeScale("50");
        request1.setElbProdCode("standardI");
        request1.setEnableApiServerEip(false);
        request1.setVpcUuid("vpc-vu2t769u81");
        request1.setSubnetUuid("subnet-7xipneei60");
        request1.setEnableSnat(false);
        request1.setNatGatewaySpec("small");
        request1.setIpStackType("ipv4");
        request1.setAutoGenerateSecurityGroup(false);
        request1.setSecurityGroupUuid("sg-8judj901ou");
        request1.setNetworkPlugin("calico");
        request1.setIpvlan(false);
        request1.setNetworkPolicy(false);
        String request2 = "";
        List<String> request3 = new ArrayList<>();
        request3.add(request2);
        request1.setPodSubnetUuidList(request3);
        request1.setPodCidr("192.168.0.0/16");
        request1.setServiceCidr("172.26.0.0/16");
        request1.setServiceCidrV6("");
        request1.setKubeProxy("iptables");
        request1.setStartPort(30000L);
        request1.setEndPort(32767L);
        request1.setSan("192.168.1.1");
        request1.setCustomCAEnable(false);
        request1.setCustomCA("");
        request1.setClusterDomain("cluster.local");
        request1.setDeleteProtection(false);
        Map<String, String> request4 = new HashMap<>();
        request1.setClusterLabels(request4);
        request1.setClusterDesc("");
        request1.setServiceAccountIssuer("");
        request1.setApiAudiences("");
        CcseCreateClusterApi.CreateClusterClusterBaseInfoKubeletArgsRequest request5 =
                new CcseCreateClusterApi.CreateClusterClusterBaseInfoKubeletArgsRequest();
        request5.setKubeAPIQPS(50);
        request5.setKubeAPIBurst(100);
        request5.setMaxPods(110);
        request5.setRegistryPullQPS(5);
        request5.setRegistryBurst(10);
        request5.setPodPidsLimit(-1);
        request5.setEventRecordQPS(50);
        request5.setEventBurst(100);
        request5.setTopologyManagerScope("container");
        request5.setCpuCFSQuota(true);
        request1.setKubeletArgs(request5);
        request1.setTimezone("Asia/Shanghai");
        request1.setNodePool("");
        CcseCreateClusterApi.CreateClusterClusterBaseInfoAzInfosRequest request6 =
                new CcseCreateClusterApi.CreateClusterClusterBaseInfoAzInfosRequest();
        request6.setAzName("cn-huabei2-tj1A-public-ctcloud");
        request6.setSize(1);
        List<CcseCreateClusterApi.CreateClusterClusterBaseInfoAzInfosRequest> request7 =
                new ArrayList<>();
        request7.add(request6);
        request1.setAzInfos(request7);
        request1.setContainerRuntime("containerd");
        request1.setLoginType("password");
        request1.setPassword("");
        request1.setKeyPairId("ba425a97-9ad9-2d45-e21a-770d2ebeb477");
        request1.setKeyName("KeyPair-a589");
        request1.setEnableHostName(false);
        request1.setHostNamePrefix("");
        request1.setHostNamePostfix("");
        request1.setNodeUnschedulable(false);
        Map<String, String> request8 = new HashMap<>();
        request1.setNodeLabels(request8);
        List<CcseCreateClusterApi.CreateClusterTaintsRequest> nodeTaints = new ArrayList<>();
        CcseCreateClusterApi.CreateClusterTaintsRequest nodeTaintsRequest =
                new CcseCreateClusterApi.CreateClusterTaintsRequest();
        nodeTaintsRequest.setKey("test");
        nodeTaintsRequest.setValue("test");
        nodeTaintsRequest.setEffect("NoSchedule");
        nodeTaints.add(nodeTaintsRequest);
        try {
            request1.setNodeTaints(new String(JacksonUtils.getObjectMapperInstance().writeValueAsBytes(nodeTaints)));
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        Map<String, String> request9 = new HashMap<>();
        request1.setResourceLabels(request9);
        request1.setSyncNodeLabels(false);
        request1.setSyncNodeTaints(false);
        request1.setCpuManagerPolicyEnable(false);
        request1.setCustomScriptBase64(false);
        request1.setHostScript("");
        request1.setEnablePostUserScript(false);
        request1.setPostUserScript("");
        request1.setEnableAffinityGroup(false);
        request1.setAffinityGroupUuid("8c66ee54-f922-75a8-1e13-af1f682f15dc");
        request1.setDelegateName("ecsadmintrust");
        request1.setK8sNodeNameType("cceNodeName");
        request1.setInstallNginxIngress(false);
        request1.setNginxIngressLBSpec("");
        request1.setNginxIngressLBNetWork("internal");
        request1.setInstallDnsCache(false);
        request1.setInstallCubeEye(false);
        request1.setEnableLts(false);
        request1.setLtsProjectName("xxxxx");
        request1.setEnableContainerLog(false);
        request1.setEnableEventLog(false);
        request1.setEnableControlPlaneLog(false);
        request1.setEnableAuditLog(false);
        request1.setEnableIngressLog(false);
        request1.setNodePoolBillingMode("1");
        request1.setNodePoolCycleType("3");
        request1.setNodePoolCycleCount(1);
        request1.setNodePoolAutoRenewStatus(false);
        request.setClusterBaseInfo(request1);
        CcseCreateClusterApi.CreateClusterMasterHostRequest request10 =
                new CcseCreateClusterApi.CreateClusterMasterHostRequest();
        request10.setItemDefName("s6.xlarge.2");
        CcseCreateClusterApi.CreateClusterMasterHostSysDiskRequest request11 =
                new CcseCreateClusterApi.CreateClusterMasterHostSysDiskRequest();
        request11.setItemDefName("SATA");
        request11.setSize(120);
        request10.setSysDisk(request11);
        CcseCreateClusterApi.CreateClusterMasterHostDataDisksRequest request12 =
                new CcseCreateClusterApi.CreateClusterMasterHostDataDisksRequest();
        request12.setItemDefName("SATA");
        request12.setSize(120);
        request12.setDecTypeId("b0d48eaf-e164-4873-9b89-e3dc85c8bed0");
        List<CcseCreateClusterApi.CreateClusterMasterHostDataDisksRequest> request13 =
                new ArrayList<>();
        request13.add(request12);
        request10.setDataDisks(request13);
        request.setMasterHost(request10);
        CcseCreateClusterApi.CreateClusterSlaveHostRequest request14 =
                new CcseCreateClusterApi.CreateClusterSlaveHostRequest();
        request14.setItemDefName("s6.xlarge.2");
        CcseCreateClusterApi.CreateClusterSlaveHostSysDiskRequest request15 =
                new CcseCreateClusterApi.CreateClusterSlaveHostSysDiskRequest();
        request15.setItemDefName("SATA");
        request15.setSize(120);
        request14.setSysDisk(request15);
        CcseCreateClusterApi.CreateClusterSlaveHostDataDisksRequest request16 =
                new CcseCreateClusterApi.CreateClusterSlaveHostDataDisksRequest();
        request16.setItemDefName("SATA");
        request16.setSize(120);
        request16.setDecTypeId("b0d48eaf-e164-4873-9b89-e3dc85c8bed0");
        List<CcseCreateClusterApi.CreateClusterSlaveHostDataDisksRequest> request17 =
                new ArrayList<>();
        request17.add(request16);
        request14.setDataDisks(request17);
        request14.setForeignMirrorId("49317128-641c-4a54-b0f1-a47992933413");
        request14.setMirrorType(1);
        request14.setMirrorName("CTyunOS-23.01-CCND_CCSE_40_08-x86_64");
        CcseCreateClusterApi.CreateClusterSlaveHostAzInfosRequest request18 =
                new CcseCreateClusterApi.CreateClusterSlaveHostAzInfosRequest();
        request18.setAzName("cn-huabei2-tj1A-public-ctcloud");
        request18.setSize(1);
        List<CcseCreateClusterApi.CreateClusterSlaveHostAzInfosRequest> request19 =
                new ArrayList<>();
        request19.add(request18);
        request14.setAzInfos(request19);
        request.setSlaveHost(request14);

        CcseCreateClusterApi.CreateClusterResponse response =
                apis.ccseCreateClusterApi.send(credential, request);
        System.out.println(response);
    }
}
