package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequestException;

import org.junit.jupiter.api.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CcseCreateNodePoolApiTest {
    @Test
    void send() throws CtyunRequestException {
        CtyunClient ctyunClient = CtyunClient.defaultClient();
        Credential credential = new Credential("<YOUR_AK>", "<YOUR_SK>");
        // Credential credential = Credential.credentialFromEnv();
        Apis apis = new Apis("<YOUR_ENDPOINT>", ctyunClient);

        CcseCreateNodePoolApi.CreateNodePoolRequest request =
                new CcseCreateNodePoolApi.CreateNodePoolRequest();
        request.setClusterId("47281b02f87757478f20b1827c97cadf");
        request.setRegionId("bb9fdb42056f11eda1610242ac110002");
        request.setNodePoolName("");
        request.setEnableAutoScale(true);
        request.setMaxNum(2);
        request.setMinNum(1);
        request.setBillMode("1");
        request.setCycleCount(0);
        request.setCycleType("MONTH");
        request.setAutoRenewStatus(0);
        CcseCreateNodePoolApi.CreateNodePoolAzInfoRequest request1 =
                new CcseCreateNodePoolApi.CreateNodePoolAzInfoRequest();
        request1.setAzName("cn-xinan1-1A");
        List<CcseCreateNodePoolApi.CreateNodePoolAzInfoRequest> request2 = new ArrayList<>();
        request2.add(request1);
        request.setAzInfo(request2);
        request.setContainerRuntime("containerd");
        request.setVmSpecName("c7.xlarge.2");
        request.setImageType(1);
        request.setImageName("Centos-79-CCND-CCSE-40-07-amd");
        request.setImageUuid("a8f857a8-ee19-4dc8-a193-819e8ed10dc9");
        request.setLoginType("password");
        request.setPassword("");
        request.setKeyName("KeyPair-a589");
        request.setKeyPairId("ba425a97-9ad9-2d45-e21a-770d2ebeb477");
        request.setSysDiskType("SATA");
        request.setSysDiskSize(0);
        request.setSysDiskDecTypeId("b0d48eaf-e164-4873-9b89-e3dc85c8bed0");
        CcseCreateNodePoolApi.CreateNodePoolDataDisksRequest request3 =
                new CcseCreateNodePoolApi.CreateNodePoolDataDisksRequest();
        request3.setSize(100);
        request3.setDiskSpecName("SATA");
        request3.setDecTypeId("b0d48eaf-e164-4873-9b89-e3dc85c8bed0");
        List<CcseCreateNodePoolApi.CreateNodePoolDataDisksRequest> request4 = new ArrayList<>();
        request4.add(request3);
        request.setDataDisks(request4);
        request.setSecurityGroupId("sg-8judj901ou");
        request.setSubnetUuid("subnet-7xipneei60");
        request.setDefinedHostnameEnable(0);
        request.setHostNamePrefix("");
        request.setHostNamePostfix("");
        request.setVisibilityHostScript("");
        request.setVisibilityPostHostScript("");
        Map<String,String> request5 = new HashMap<>();
        request.setLabels(request5);
        Map<String,String>  request6 = new HashMap<>();
        request.setAnnotations(request6);
        CcseCreateNodePoolApi.CreateNodePoolTaintsRequest request7 =
                new CcseCreateNodePoolApi.CreateNodePoolTaintsRequest();
        request7.setKey("aaa");
        request7.setValue("bbb");
        request7.setEffect("NoSchedule");
        List<CcseCreateNodePoolApi.CreateNodePoolTaintsRequest> request8 = new ArrayList<>();
        request8.add(request7);
        request.setTaints(request8);
        request.setSyncNodeLabels(false);
        request.setSyncNodeAnnotations(false);
        request.setSyncNodeTaints(false);
        CcseCreateNodePoolApi.CreateNodePoolKubeletArgsRequest request9 =
                new CcseCreateNodePoolApi.CreateNodePoolKubeletArgsRequest();
        request9.setKubeAPIQPS(50);
        request9.setKubeAPIBurst(100);
        request9.setMaxPods(110);
        request9.setRegistryPullQPS(5);
        request9.setRegistryBurst(10);
        request9.setPodPidsLimit(-1);
        request9.setEventRecordQPS(50);
        request9.setEventBurst(100);
        request9.setTopologyManagerScope("container");
        request9.setCpuCFSQuota(true);
        request.setKubeletArgs(request9);
        request.setK8sNodeNameType("cceNodeName");
        request.setNodeUnschedulable(false);
        request.setIsSyncClusterResourceLabels(false);
        Map<String,String>  request10 = new HashMap<>();
        request.setResourceLabels(request10);
        request.setKubeletDirectory("");
        request.setContainerDataDirectory("");
        request.setUseAffinityGroup(false);
        request.setAffinityGroupUuid("");
        request.setAutoRepair(0);
        request.setDescription("");

        CcseCreateNodePoolApi.CreateNodePoolResponse response =
                apis.ccseCreateNodePoolApi.send(credential, request);
        System.out.println(response);
    }
}
